/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.bulk.DeleteRequest;
import com.mongodb.connection.BaseWriteCommandMessage;
import com.mongodb.connection.MessageSettings;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import java.util.Collections;
import java.util.List;
import org.bson.BsonBinaryWriter;
import org.bson.BsonDocument;
import org.bson.BsonWriter;
import org.bson.FieldNameValidator;
import org.bson.codecs.EncoderContext;
import org.bson.io.BsonOutput;

class DeleteCommandMessage
extends BaseWriteCommandMessage {
    private final List<DeleteRequest> deletes;

    DeleteCommandMessage(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, MessageSettings settings, List<DeleteRequest> deletes) {
        super(namespace, ordered, writeConcern, null, settings);
        this.deletes = deletes;
    }

    @Override
    public int getItemCount() {
        return this.deletes.size();
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        return new NoOpFieldNameValidator();
    }

    public List<DeleteRequest> getRequests() {
        return Collections.unmodifiableList(this.deletes);
    }

    @Override
    protected String getCommandName() {
        return "delete";
    }

    @Override
    protected BaseWriteCommandMessage writeTheWrites(BsonOutput bsonOutput, int commandStartPosition, BsonBinaryWriter writer) {
        DeleteCommandMessage nextMessage = null;
        writer.writeStartArray("deletes");
        for (int i = 0; i < this.deletes.size(); ++i) {
            writer.mark();
            DeleteRequest deleteRequest = this.deletes.get(i);
            writer.writeStartDocument();
            writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
            writer.writeName("q");
            this.getCodec(deleteRequest.getFilter()).encode((BsonWriter)writer, (Object)deleteRequest.getFilter(), EncoderContext.builder().build());
            writer.writeInt32("limit", deleteRequest.isMulti() ? 0 : 1);
            if (deleteRequest.getCollation() != null) {
                writer.writeName("collation");
                BsonDocument collation = deleteRequest.getCollation().asDocument();
                this.getCodec(collation).encode((BsonWriter)writer, (Object)collation, EncoderContext.builder().build());
            }
            writer.popMaxDocumentSize();
            writer.writeEndDocument();
            if (!this.exceedsLimits(bsonOutput.getPosition() - commandStartPosition, i + 1)) continue;
            writer.reset();
            nextMessage = new DeleteCommandMessage(this.getWriteNamespace(), this.isOrdered(), this.getWriteConcern(), this.getSettings(), this.deletes.subList(i, this.deletes.size()));
            break;
        }
        writer.writeEndArray();
        return nextMessage;
    }
}

