/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.CompositeByteBuf;
import com.mongodb.connection.ResponseBuffers;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.BsonBinaryReader;
import org.bson.BsonDocument;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.ByteBuf;
import org.bson.RawBsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.io.BsonInput;
import org.bson.io.ByteBufferBsonInput;
import org.bson.json.JsonWriter;
import org.bson.json.JsonWriterSettings;

class ByteBufBsonDocument
extends BsonDocument
implements Cloneable {
    private static final long serialVersionUID = 1L;
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()});
    private final transient ByteBuf byteBuf;

    static List<ByteBufBsonDocument> create(ResponseBuffers responseBuffers) {
        int numDocuments = responseBuffers.getReplyHeader().getNumberReturned();
        ByteBuf documentsBuffer = responseBuffers.getBodyByteBuffer();
        documentsBuffer.order(ByteOrder.LITTLE_ENDIAN);
        ArrayList<ByteBufBsonDocument> documents = new ArrayList<ByteBufBsonDocument>(numDocuments);
        while (documents.size() < numDocuments) {
            int documentSizeInBytes = documentsBuffer.getInt();
            documentsBuffer.position(documentsBuffer.position() - 4);
            ByteBuf documentBuffer = documentsBuffer.duplicate();
            documentBuffer.limit(documentBuffer.position() + documentSizeInBytes);
            documents.add(new ByteBufBsonDocument(documentBuffer));
            documentsBuffer.position(documentsBuffer.position() + documentSizeInBytes);
        }
        return documents;
    }

    static ByteBufBsonDocument createOne(ByteBufferBsonOutput bsonOutput, int startPosition) {
        return ByteBufBsonDocument.create(bsonOutput, startPosition).get(0);
    }

    static List<ByteBufBsonDocument> create(ByteBufferBsonOutput bsonOutput, int startPosition) {
        List<ByteBuf> duplicateByteBuffers = bsonOutput.getByteBuffers();
        CompositeByteBuf outputByteBuf = new CompositeByteBuf(duplicateByteBuffers);
        outputByteBuf.position(startPosition);
        ArrayList<ByteBufBsonDocument> documents = new ArrayList<ByteBufBsonDocument>();
        int curDocumentStartPosition = startPosition;
        while (outputByteBuf.hasRemaining()) {
            int documentSizeInBytes = outputByteBuf.getInt();
            ByteBuf slice = outputByteBuf.duplicate();
            slice.position(curDocumentStartPosition);
            slice.limit(curDocumentStartPosition + documentSizeInBytes);
            documents.add(new ByteBufBsonDocument(slice));
            curDocumentStartPosition += documentSizeInBytes;
            outputByteBuf.position(outputByteBuf.position() + documentSizeInBytes - 4);
        }
        for (ByteBuf byteBuffer : duplicateByteBuffers) {
            byteBuffer.release();
        }
        return documents;
    }

    public void clear() {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    public BsonValue put(String key, BsonValue value) {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    public BsonDocument append(String key, BsonValue value) {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    public void putAll(Map<? extends String, ? extends BsonValue> m) {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    public BsonValue remove(Object key) {
        throw new UnsupportedOperationException("RawBsonDocument instances are immutable");
    }

    public boolean isEmpty() {
        return this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(BsonReader bsonReader) {
                return false;
            }

            @Override
            public Boolean notFound() {
                return true;
            }
        });
    }

    public int size() {
        return this.findInDocument(new Finder<Integer>(){
            private int size;

            @Override
            public Integer find(BsonReader bsonReader) {
                ++this.size;
                bsonReader.readName();
                bsonReader.skipValue();
                return null;
            }

            @Override
            public Integer notFound() {
                return this.size;
            }
        });
    }

    public Set<Map.Entry<String, BsonValue>> entrySet() {
        return this.toBsonDocument().entrySet();
    }

    public Collection<BsonValue> values() {
        return this.toBsonDocument().values();
    }

    public Set<String> keySet() {
        return this.toBsonDocument().keySet();
    }

    public boolean containsKey(final Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        return this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(BsonReader bsonReader) {
                if (bsonReader.readName().equals(key)) {
                    return true;
                }
                bsonReader.skipValue();
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
    }

    public boolean containsValue(final Object value) {
        return this.findInDocument(new Finder<Boolean>(){

            @Override
            public Boolean find(BsonReader bsonReader) {
                bsonReader.skipName();
                if (ByteBufBsonDocument.this.deserializeBsonValue(bsonReader).equals(value)) {
                    return true;
                }
                return null;
            }

            @Override
            public Boolean notFound() {
                return false;
            }
        });
    }

    public BsonValue get(final Object key) {
        if (key == null) {
            throw new IllegalArgumentException("key can not be null");
        }
        return this.findInDocument(new Finder<BsonValue>(){

            @Override
            public BsonValue find(BsonReader bsonReader) {
                if (bsonReader.readName().equals(key)) {
                    return ByteBufBsonDocument.this.deserializeBsonValue(bsonReader);
                }
                bsonReader.skipValue();
                return null;
            }

            @Override
            public BsonValue notFound() {
                return null;
            }
        });
    }

    public String toJson() {
        return this.toJson(new JsonWriterSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toJson(JsonWriterSettings settings) {
        StringWriter stringWriter = new StringWriter();
        JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter, settings);
        ByteBuf duplicate = this.byteBuf.duplicate();
        BsonBinaryReader reader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(duplicate));
        try {
            jsonWriter.pipe((BsonReader)reader);
            String string = stringWriter.toString();
            return string;
        }
        finally {
            duplicate.release();
            reader.close();
        }
    }

    public String getFirstKey() {
        return this.findInDocument(new Finder<String>(){

            @Override
            public String find(BsonReader bsonReader) {
                return bsonReader.readName();
            }

            @Override
            public String notFound() {
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T findInDocument(Finder<T> finder) {
        ByteBuf duplicateByteBuf = this.byteBuf.duplicate();
        BsonBinaryReader bsonReader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(duplicateByteBuf));
        try {
            bsonReader.readStartDocument();
            while (bsonReader.readBsonType() != BsonType.END_OF_DOCUMENT) {
                T found = finder.find((BsonReader)bsonReader);
                if (found == null) continue;
                T t = found;
                return t;
            }
            bsonReader.readEndDocument();
        }
        finally {
            duplicateByteBuf.release();
            bsonReader.close();
        }
        return finder.notFound();
    }

    public BsonDocument clone() {
        byte[] clonedBytes = new byte[this.byteBuf.remaining()];
        this.byteBuf.get(this.byteBuf.position(), clonedBytes);
        return new RawBsonDocument(clonedBytes);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return this.toBsonDocument().equals(o);
    }

    public int hashCode() {
        return this.toBsonDocument().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BsonDocument toBsonDocument() {
        ByteBuf duplicateByteBuf = this.byteBuf.duplicate();
        BsonBinaryReader bsonReader = new BsonBinaryReader((BsonInput)new ByteBufferBsonInput(duplicateByteBuf));
        try {
            BsonDocument bsonDocument = new BsonDocumentCodec().decode((BsonReader)bsonReader, DecoderContext.builder().build());
            return bsonDocument;
        }
        finally {
            duplicateByteBuf.release();
            bsonReader.close();
        }
    }

    private BsonValue deserializeBsonValue(BsonReader bsonReader) {
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType((BsonType)bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
    }

    ByteBufBsonDocument(ByteBuf byteBuf) {
        this.byteBuf = byteBuf;
    }

    private Object writeReplace() {
        return this.toBsonDocument();
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Proxy required");
    }

    private static interface Finder<T> {
        public T find(BsonReader var1);

        public T notFound();
    }
}

