/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.MultiPoint;
import com.mongodb.client.model.geojson.Position;
import com.mongodb.client.model.geojson.codecs.GeometryCodecHelper;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class MultiPointCodec
implements Codec<MultiPoint> {
    private final CodecRegistry registry;

    public MultiPointCodec(CodecRegistry registry) {
        this.registry = Assertions.notNull("registry", registry);
    }

    public void encode(final BsonWriter writer, final MultiPoint value, EncoderContext encoderContext) {
        GeometryCodecHelper.encodeGeometry(writer, value, encoderContext, this.registry, new Runnable(){

            @Override
            public void run() {
                writer.writeStartArray();
                for (Position position : value.getCoordinates()) {
                    GeometryCodecHelper.encodePosition(writer, position);
                }
                writer.writeEndArray();
            }
        });
    }

    public Class<MultiPoint> getEncoderClass() {
        return MultiPoint.class;
    }

    public MultiPoint decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }
}

