/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model.geojson.codecs;

import com.mongodb.assertions.Assertions;
import com.mongodb.client.model.geojson.MultiLineString;
import com.mongodb.client.model.geojson.Position;
import com.mongodb.client.model.geojson.codecs.GeometryCodecHelper;
import java.util.List;
import org.bson.BsonReader;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;

public class MultiLineStringCodec
implements Codec<MultiLineString> {
    private final CodecRegistry registry;

    public MultiLineStringCodec(CodecRegistry registry) {
        this.registry = Assertions.notNull("registry", registry);
    }

    public void encode(final BsonWriter writer, final MultiLineString value, EncoderContext encoderContext) {
        GeometryCodecHelper.encodeGeometry(writer, value, encoderContext, this.registry, new Runnable(){

            @Override
            public void run() {
                writer.writeStartArray();
                for (List<Position> ring : value.getCoordinates()) {
                    writer.writeStartArray();
                    for (Position position : ring) {
                        GeometryCodecHelper.encodePosition(writer, position);
                    }
                    writer.writeEndArray();
                }
                writer.writeEndArray();
            }
        });
    }

    public Class<MultiLineString> getEncoderClass() {
        return MultiLineString.class;
    }

    public MultiLineString decode(BsonReader reader, DecoderContext decoderContext) {
        throw new UnsupportedOperationException("Not implemented yet!");
    }
}

