/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ReadBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.QueryResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.ReadOperation;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class UserExistsOperation
implements AsyncReadOperation<Boolean>,
ReadOperation<Boolean> {
    private final String databaseName;
    private final String userName;

    public UserExistsOperation(String databaseName, String userName) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
        this.userName = Assertions.notNull("userName", userName);
    }

    @Override
    public Boolean execute(final ReadBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Boolean>(){

            @Override
            public Boolean call(Connection connection) {
                if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                    return (Boolean)CommandOperationHelper.executeWrappedCommandProtocol(binding, UserExistsOperation.this.databaseName, UserExistsOperation.this.getCommand(), connection, UserExistsOperation.this.transformer());
                }
                return (Boolean)UserExistsOperation.this.transformQueryResult().apply(connection.query(new MongoNamespace(UserExistsOperation.this.databaseName, "system.users"), new BsonDocument("user", (BsonValue)new BsonString(UserExistsOperation.this.userName)), (BsonDocument)null, 0, 1, 0, binding.getReadPreference().isSlaveOk(), false, false, false, false, false, new BsonDocumentCodec()));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<Boolean> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    ErrorHandlingResultCallback.errorHandlingCallback(callback).onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback), connection);
                    if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, UserExistsOperation.this.databaseName, UserExistsOperation.this.getCommand(), (Decoder<BsonDocument>)new BsonDocumentCodec(), connection, UserExistsOperation.this.transformer(), wrappedCallback);
                    } else {
                        connection.queryAsync(new MongoNamespace(UserExistsOperation.this.databaseName, "system.users"), new BsonDocument("user", (BsonValue)new BsonString(UserExistsOperation.this.userName)), (BsonDocument)null, 0, 1, 0, binding.getReadPreference().isSlaveOk(), false, false, false, false, false, new BsonDocumentCodec(), new SingleResultCallback<QueryResult<BsonDocument>>(){

                            @Override
                            public void onResult(QueryResult<BsonDocument> result, Throwable t) {
                                if (t != null) {
                                    wrappedCallback.onResult(null, t);
                                } else {
                                    try {
                                        wrappedCallback.onResult(UserExistsOperation.this.transformQueryResult().apply(result), null);
                                    }
                                    catch (Throwable tr) {
                                        wrappedCallback.onResult(null, tr);
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    private Function<BsonDocument, Boolean> transformer() {
        return new Function<BsonDocument, Boolean>(){

            @Override
            public Boolean apply(BsonDocument result) {
                return result.get((Object)"users").isArray() && !result.getArray((Object)"users").isEmpty();
            }
        };
    }

    private Function<QueryResult<BsonDocument>, Boolean> transformQueryResult() {
        return new Function<QueryResult<BsonDocument>, Boolean>(){

            @Override
            public Boolean apply(QueryResult<BsonDocument> queryResult) {
                return !queryResult.getResults().isEmpty();
            }
        };
    }

    private BsonDocument getCommand() {
        return new BsonDocument("usersInfo", (BsonValue)new BsonString(this.userName));
    }
}

