/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;
import com.mongodb.internal.validator.MappedFieldNameValidator;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.FindAndModifyHelper;
import com.mongodb.operation.WriteOperation;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.Decoder;

public class FindAndReplaceOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private final BsonDocument replacement;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private long maxTimeMS;
    private boolean returnOriginal = true;
    private boolean upsert;

    public FindAndReplaceOperation(MongoNamespace namespace, Decoder<T> decoder, BsonDocument replacement) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
        this.replacement = Assertions.notNull("replacement", replacement);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getReplacement() {
        return this.replacement;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindAndReplaceOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindAndReplaceOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindAndReplaceOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindAndReplaceOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public boolean isReturnOriginal() {
        return this.returnOriginal;
    }

    public FindAndReplaceOperation<T> returnOriginal(boolean returnOriginal) {
        this.returnOriginal = returnOriginal;
        return this;
    }

    public boolean isUpsert() {
        return this.upsert;
    }

    public FindAndReplaceOperation<T> upsert(boolean upsert) {
        this.upsert = upsert;
        return this;
    }

    @Override
    public T execute(WriteBinding binding) {
        return CommandOperationHelper.executeWrappedCommandProtocol(binding, this.namespace.getDatabaseName(), this.getCommand(), this.getValidator(), CommandResultDocumentCodec.create(this.decoder, "value"), FindAndModifyHelper.<BsonDocument>transformer());
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, this.namespace.getDatabaseName(), this.getCommand(), this.getValidator(), CommandResultDocumentCodec.create(this.decoder, "value"), FindAndModifyHelper.<BsonDocument>transformer(), callback);
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("findandmodify", (BsonValue)new BsonString(this.namespace.getCollectionName()));
        DocumentHelper.putIfNotNull(command, "query", (BsonValue)this.getFilter());
        DocumentHelper.putIfNotNull(command, "fields", (BsonValue)this.getProjection());
        DocumentHelper.putIfNotNull(command, "sort", (BsonValue)this.getSort());
        DocumentHelper.putIfTrue(command, "new", !this.isReturnOriginal());
        DocumentHelper.putIfTrue(command, "upsert", this.isUpsert());
        DocumentHelper.putIfNotZero(command, "maxTimeMS", this.getMaxTime(TimeUnit.MILLISECONDS));
        command.put("update", (BsonValue)this.getReplacement());
        return command;
    }

    private FieldNameValidator getValidator() {
        HashMap<String, FieldNameValidator> map = new HashMap<String, FieldNameValidator>();
        map.put("update", new CollectibleDocumentFieldNameValidator());
        return new MappedFieldNameValidator(new NoOpFieldNameValidator(), map);
    }
}

