/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.FindAndModifyHelper;
import com.mongodb.operation.WriteOperation;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.Decoder;

public class FindAndDeleteOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private long maxTimeMS;

    public FindAndDeleteOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindAndDeleteOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindAndDeleteOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindAndDeleteOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindAndDeleteOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    @Override
    public T execute(WriteBinding binding) {
        return CommandOperationHelper.executeWrappedCommandProtocol(this.namespace.getDatabaseName(), this.getFindAndRemoveDocument(), CommandResultDocumentCodec.create(this.decoder, "value"), binding, FindAndModifyHelper.<BsonDocument>transformer());
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(this.namespace.getDatabaseName(), this.getFindAndRemoveDocument(), CommandResultDocumentCodec.create(this.decoder, "value"), binding, FindAndModifyHelper.<BsonDocument>transformer(), callback);
    }

    private BsonDocument getFindAndRemoveDocument() {
        BsonDocument command = new BsonDocument("findandmodify", (BsonValue)new BsonString(this.namespace.getCollectionName()));
        DocumentHelper.putIfNotNull(command, "query", (BsonValue)this.getFilter());
        DocumentHelper.putIfNotNull(command, "fields", (BsonValue)this.getProjection());
        DocumentHelper.putIfNotNull(command, "sort", (BsonValue)this.getSort());
        DocumentHelper.putIfNotZero(command, "maxTimeMS", this.getMaxTime(TimeUnit.MILLISECONDS));
        command.put("remove", (BsonValue)BsonBoolean.TRUE);
        return command;
    }
}

