/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonValue;

public class DropDatabaseOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private static final BsonDocument DROP_DATABASE = new BsonDocument("dropDatabase", (BsonValue)new BsonInt32(1));
    private final String databaseName;

    public DropDatabaseOperation(String databaseName) {
        this.databaseName = Assertions.notNull("databaseName", databaseName);
    }

    @Override
    public Void execute(WriteBinding binding) {
        return (Void)CommandOperationHelper.executeWrappedCommandProtocol(this.databaseName, DROP_DATABASE, binding, new OperationHelper.VoidTransformer<BsonDocument>());
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, SingleResultCallback<Void> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(this.databaseName, DROP_DATABASE, binding, new OperationHelper.VoidTransformer<BsonDocument>(), callback);
    }
}

