/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import java.util.List;
import org.bson.io.BsonOutput;

class KillCursorsMessage
extends RequestMessage {
    private final List<Long> cursors;

    public KillCursorsMessage(List<Long> cursors) {
        super(RequestMessage.OpCode.OP_KILL_CURSORS, MessageSettings.builder().build());
        this.cursors = Assertions.notNull("cursors", cursors);
    }

    @Override
    protected RequestMessage encodeMessageBody(BsonOutput bsonOutput, int messageStartPosition) {
        this.writeKillCursorsPrologue(this.cursors.size(), bsonOutput);
        for (Long cur : this.cursors) {
            bsonOutput.writeInt64(cur.longValue());
        }
        return null;
    }

    private void writeKillCursorsPrologue(int numCursors, BsonOutput bsonOutput) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeInt32(numCursors);
    }
}

