/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.ExplainVerbosity;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.QueryResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.BsonDocumentWrapperHelper;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.CommandReadOperation;
import com.mongodb.operation.CommandResultDocumentCodec;
import com.mongodb.operation.DocumentHelper;
import com.mongodb.operation.ExplainHelper;
import com.mongodb.operation.MapReduceAsyncBatchCursor;
import com.mongodb.operation.MapReduceBatchCursor;
import com.mongodb.operation.MapReduceHelper;
import com.mongodb.operation.MapReduceInlineResultsAsyncCursor;
import com.mongodb.operation.MapReduceInlineResultsCursor;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.ReadOperation;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonJavaScript;
import org.bson.BsonNull;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

public class MapReduceWithInlineResultsOperation<T>
implements AsyncReadOperation<MapReduceAsyncBatchCursor<T>>,
ReadOperation<MapReduceBatchCursor<T>> {
    private final MongoNamespace namespace;
    private final BsonJavaScript mapFunction;
    private final BsonJavaScript reduceFunction;
    private final Decoder<T> decoder;
    private BsonJavaScript finalizeFunction;
    private BsonDocument scope;
    private BsonDocument filter;
    private BsonDocument sort;
    private int limit;
    private boolean jsMode;
    private boolean verbose;
    private long maxTimeMS;

    public MapReduceWithInlineResultsOperation(MongoNamespace namespace, BsonJavaScript mapFunction, BsonJavaScript reduceFunction, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.mapFunction = Assertions.notNull("mapFunction", mapFunction);
        this.reduceFunction = Assertions.notNull("reduceFunction", reduceFunction);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public BsonJavaScript getMapFunction() {
        return this.mapFunction;
    }

    public BsonJavaScript getReduceFunction() {
        return this.reduceFunction;
    }

    public BsonJavaScript getFinalizeFunction() {
        return this.finalizeFunction;
    }

    public MapReduceWithInlineResultsOperation<T> finalizeFunction(BsonJavaScript finalizeFunction) {
        this.finalizeFunction = finalizeFunction;
        return this;
    }

    public BsonDocument getScope() {
        return this.scope;
    }

    public MapReduceWithInlineResultsOperation<T> scope(BsonDocument scope) {
        this.scope = scope;
        return this;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public MapReduceWithInlineResultsOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public MapReduceWithInlineResultsOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public MapReduceWithInlineResultsOperation<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public boolean isJsMode() {
        return this.jsMode;
    }

    public MapReduceWithInlineResultsOperation<T> jsMode(boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public MapReduceWithInlineResultsOperation<T> verbose(boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public MapReduceWithInlineResultsOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public MapReduceBatchCursor<T> execute(ReadBinding binding) {
        return (MapReduceBatchCursor)OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnectionAndSource<MapReduceBatchCursor<T>>(){

            @Override
            public MapReduceBatchCursor<T> call(ConnectionSource source, Connection connection) {
                return (MapReduceBatchCursor)CommandOperationHelper.executeWrappedCommandProtocol(MapReduceWithInlineResultsOperation.this.namespace.getDatabaseName(), MapReduceWithInlineResultsOperation.this.getCommand(), CommandResultDocumentCodec.create(MapReduceWithInlineResultsOperation.this.decoder, "results"), connection, MapReduceWithInlineResultsOperation.this.transformer(source, connection));
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<MapReduceAsyncBatchCursor<T>> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    ErrorHandlingResultCallback.errorHandlingCallback(callback).onResult(null, t);
                } else {
                    CommandOperationHelper.executeWrappedCommandProtocolAsync(MapReduceWithInlineResultsOperation.this.namespace.getDatabaseName(), MapReduceWithInlineResultsOperation.this.getCommand(), CommandResultDocumentCodec.create(MapReduceWithInlineResultsOperation.this.decoder, "results"), connection, binding.getReadPreference(), MapReduceWithInlineResultsOperation.this.asyncTransformer(connection), OperationHelper.releasingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback), connection));
                }
            }
        });
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.namespace.getDatabaseName(), ExplainHelper.asExplainCommand(this.getCommand(), explainVerbosity), (Decoder<BsonDocument>)new BsonDocumentCodec());
    }

    private Function<BsonDocument, MapReduceBatchCursor<T>> transformer(final ConnectionSource source, final Connection connection) {
        return new Function<BsonDocument, MapReduceBatchCursor<T>>(){

            @Override
            public MapReduceBatchCursor<T> apply(BsonDocument result) {
                return new MapReduceInlineResultsCursor(MapReduceWithInlineResultsOperation.this.createQueryResult(result, connection.getDescription()), MapReduceWithInlineResultsOperation.this.decoder, source, MapReduceHelper.createStatistics(result));
            }
        };
    }

    private Function<BsonDocument, MapReduceAsyncBatchCursor<T>> asyncTransformer(final AsyncConnection connection) {
        return new Function<BsonDocument, MapReduceAsyncBatchCursor<T>>(){

            @Override
            public MapReduceAsyncBatchCursor<T> apply(BsonDocument result) {
                return new MapReduceInlineResultsAsyncCursor(MapReduceWithInlineResultsOperation.this.createQueryResult(result, connection.getDescription()), MapReduceWithInlineResultsOperation.this.decoder, MapReduceHelper.createStatistics(result));
            }
        };
    }

    private BsonDocument getCommand() {
        BsonDocument commandDocument = new BsonDocument("mapreduce", (BsonValue)new BsonString(this.namespace.getCollectionName())).append("map", (BsonValue)this.getMapFunction()).append("reduce", (BsonValue)this.getReduceFunction()).append("out", (BsonValue)new BsonDocument("inline", (BsonValue)new BsonInt32(1))).append("query", MapReduceWithInlineResultsOperation.asValueOrNull((BsonValue)this.getFilter())).append("sort", MapReduceWithInlineResultsOperation.asValueOrNull((BsonValue)this.getSort())).append("finalize", MapReduceWithInlineResultsOperation.asValueOrNull((BsonValue)this.getFinalizeFunction())).append("scope", MapReduceWithInlineResultsOperation.asValueOrNull((BsonValue)this.getScope())).append("verbose", (BsonValue)BsonBoolean.valueOf((boolean)this.isVerbose()));
        DocumentHelper.putIfNotZero(commandDocument, "limit", this.getLimit());
        DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", this.getMaxTime(TimeUnit.MILLISECONDS));
        DocumentHelper.putIfTrue(commandDocument, "jsMode", this.isJsMode());
        return commandDocument;
    }

    private QueryResult<T> createQueryResult(BsonDocument result, ConnectionDescription description) {
        return new QueryResult(this.namespace, BsonDocumentWrapperHelper.toList(result, "results"), 0L, description.getServerAddress());
    }

    private static BsonValue asValueOrNull(BsonValue value) {
        return value == null ? BsonNull.VALUE : value;
    }
}

