/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoInternalException;
import com.mongodb.ServerAddress;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.WriteConcernError;
import com.mongodb.bulk.WriteRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonNumber;
import org.bson.BsonValue;

final class WriteCommandResultHelper {
    static boolean hasError(BsonDocument result) {
        return result.get((Object)"writeErrors") != null || result.get((Object)"writeConcernError") != null;
    }

    static BulkWriteResult getBulkWriteResult(WriteRequest.Type type, BsonDocument result) {
        int count = WriteCommandResultHelper.getCount(result);
        List<BulkWriteUpsert> upsertedItems = WriteCommandResultHelper.getUpsertedItems(result);
        return BulkWriteResult.acknowledged(type, count - upsertedItems.size(), WriteCommandResultHelper.getModifiedCount(type, result), upsertedItems);
    }

    static MongoBulkWriteException getBulkWriteException(WriteRequest.Type type, BsonDocument result, ServerAddress serverAddress) {
        if (!WriteCommandResultHelper.hasError(result)) {
            throw new MongoInternalException("This method should not have been called");
        }
        return new MongoBulkWriteException(WriteCommandResultHelper.getBulkWriteResult(type, result), WriteCommandResultHelper.getWriteErrors(result), WriteCommandResultHelper.getWriteConcernError(result), serverAddress);
    }

    private static List<BulkWriteError> getWriteErrors(BsonDocument result) {
        ArrayList<BulkWriteError> writeErrors = new ArrayList<BulkWriteError>();
        BsonArray writeErrorsDocuments = (BsonArray)result.get((Object)"writeErrors");
        if (writeErrorsDocuments != null) {
            for (BsonValue cur : writeErrorsDocuments) {
                BsonDocument curDocument = (BsonDocument)cur;
                writeErrors.add(new BulkWriteError(curDocument.getNumber((Object)"code").intValue(), curDocument.getString((Object)"errmsg").getValue(), curDocument.getDocument((Object)"errInfo", new BsonDocument()), curDocument.getNumber((Object)"index").intValue()));
            }
        }
        return writeErrors;
    }

    private static WriteConcernError getWriteConcernError(BsonDocument result) {
        BsonDocument writeConcernErrorDocument = (BsonDocument)result.get((Object)"writeConcernError");
        if (writeConcernErrorDocument == null) {
            return null;
        }
        return new WriteConcernError(writeConcernErrorDocument.getNumber((Object)"code").intValue(), writeConcernErrorDocument.getString((Object)"errmsg").getValue(), writeConcernErrorDocument.getDocument((Object)"errInfo", new BsonDocument()));
    }

    private static List<BulkWriteUpsert> getUpsertedItems(BsonDocument result) {
        BsonValue upsertedValue = result.get((Object)"upserted");
        if (upsertedValue == null) {
            return Collections.emptyList();
        }
        ArrayList<BulkWriteUpsert> bulkWriteUpsertList = new ArrayList<BulkWriteUpsert>();
        for (BsonValue upsertedItem : (BsonArray)upsertedValue) {
            BsonDocument upsertedItemDocument = (BsonDocument)upsertedItem;
            bulkWriteUpsertList.add(new BulkWriteUpsert(upsertedItemDocument.getNumber((Object)"index").intValue(), upsertedItemDocument.get((Object)"_id")));
        }
        return bulkWriteUpsertList;
    }

    private static int getCount(BsonDocument result) {
        return result.getNumber((Object)"n").intValue();
    }

    private static Integer getModifiedCount(WriteRequest.Type type, BsonDocument result) {
        BsonNumber modifiedCount = result.getNumber((Object)"nModified", type == WriteRequest.Type.UPDATE || type == WriteRequest.Type.REPLACE ? null : new BsonInt32(0));
        return modifiedCount == null ? null : Integer.valueOf(modifiedCount.intValue());
    }

    private WriteCommandResultHelper() {
    }
}

