/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection.netty;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.bson.ByteBuf;

final class NettyByteBuf
implements ByteBuf {
    private io.netty.buffer.ByteBuf proxied;
    private boolean isWriting = true;

    public NettyByteBuf(io.netty.buffer.ByteBuf proxied) {
        this.proxied = proxied;
    }

    public NettyByteBuf(io.netty.buffer.ByteBuf proxied, boolean isWriting) {
        this(proxied);
        this.isWriting = isWriting;
    }

    io.netty.buffer.ByteBuf asByteBuf() {
        return this.proxied;
    }

    public int capacity() {
        return this.proxied.capacity();
    }

    public ByteBuf put(int index, byte b) {
        this.proxied.setByte(index, (int)b);
        return this;
    }

    public int remaining() {
        if (this.isWriting) {
            return this.proxied.writableBytes();
        }
        return this.proxied.readableBytes();
    }

    public ByteBuf put(byte[] src, int offset, int length) {
        this.proxied.writeBytes(src, offset, length);
        return this;
    }

    public boolean hasRemaining() {
        return this.remaining() > 0;
    }

    public ByteBuf put(byte b) {
        this.proxied.writeByte((int)b);
        return this;
    }

    public ByteBuf flip() {
        this.isWriting = !this.isWriting;
        return this;
    }

    public byte[] array() {
        return this.proxied.array();
    }

    public int limit() {
        if (this.isWriting) {
            return this.proxied.writerIndex() + this.remaining();
        }
        return this.proxied.readerIndex() + this.remaining();
    }

    public ByteBuf position(int newPosition) {
        if (this.isWriting) {
            this.proxied.writerIndex(newPosition);
        } else {
            this.proxied.readerIndex(newPosition);
        }
        return this;
    }

    public ByteBuf clear() {
        this.proxied.clear();
        return this;
    }

    public ByteBuf order(ByteOrder byteOrder) {
        this.proxied = this.proxied.order(byteOrder);
        return this;
    }

    public byte get() {
        return this.proxied.readByte();
    }

    public ByteBuf get(byte[] bytes) {
        this.proxied.readBytes(bytes);
        return this;
    }

    public ByteBuf get(byte[] bytes, int offset, int length) {
        this.proxied.readBytes(bytes, offset, length);
        return this;
    }

    public long getLong() {
        return this.proxied.readLong();
    }

    public double getDouble() {
        return this.proxied.readDouble();
    }

    public int getInt() {
        return this.proxied.readInt();
    }

    public int position() {
        if (this.isWriting) {
            return this.proxied.writerIndex();
        }
        return this.proxied.readerIndex();
    }

    public ByteBuf limit(int newLimit) {
        throw new UnsupportedOperationException("This method should be unused!");
    }

    public ByteBuf asReadOnly() {
        return this;
    }

    public ByteBuf duplicate() {
        return new NettyByteBuf(this.proxied.duplicate(), this.isWriting);
    }

    public ByteBuffer asNIO() {
        if (this.isWriting) {
            return this.proxied.nioBuffer(this.proxied.writerIndex(), this.proxied.writableBytes());
        }
        return this.proxied.nioBuffer(this.proxied.readerIndex(), this.proxied.readableBytes());
    }

    public int getReferenceCount() {
        return this.proxied.refCnt();
    }

    public ByteBuf retain() {
        this.proxied.retain();
        return this;
    }

    public void release() {
        this.proxied.release();
    }
}

