/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.MongoNamespace;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.ByteBufferBsonOutput;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.Protocol;
import com.mongodb.connection.ProtocolHelper;
import com.mongodb.connection.QueryMessage;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.QueryResultCallback;
import com.mongodb.connection.ReplyMessage;
import com.mongodb.connection.ResponseBuffers;
import com.mongodb.connection.SendMessageCallback;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import org.bson.BsonDocument;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;
import org.bson.io.BsonOutput;

class QueryProtocol<T>
implements Protocol<QueryResult<T>> {
    public static final Logger LOGGER = Loggers.getLogger("protocol.query");
    private final int skip;
    private final int numberToReturn;
    private final BsonDocument queryDocument;
    private final BsonDocument fields;
    private final Decoder<T> resultDecoder;
    private final MongoNamespace namespace;
    private boolean tailableCursor;
    private boolean slaveOk;
    private boolean oplogReplay;
    private boolean noCursorTimeout;
    private boolean awaitData;
    private boolean partial;

    public QueryProtocol(MongoNamespace namespace, int skip, int numberToReturn, BsonDocument queryDocument, BsonDocument fields, Decoder<T> resultDecoder) {
        this.namespace = namespace;
        this.skip = skip;
        this.numberToReturn = numberToReturn;
        this.queryDocument = queryDocument;
        this.fields = fields;
        this.resultDecoder = resultDecoder;
    }

    public boolean isTailableCursor() {
        return this.tailableCursor;
    }

    public QueryProtocol<T> tailableCursor(boolean tailableCursor) {
        this.tailableCursor = tailableCursor;
        return this;
    }

    public boolean isSlaveOk() {
        return this.slaveOk;
    }

    public QueryProtocol<T> slaveOk(boolean slaveOk) {
        this.slaveOk = slaveOk;
        return this;
    }

    public boolean isOplogReplay() {
        return this.oplogReplay;
    }

    public QueryProtocol<T> oplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public QueryProtocol<T> noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public boolean isAwaitData() {
        return this.awaitData;
    }

    public QueryProtocol<T> awaitData(boolean awaitData) {
        this.awaitData = awaitData;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public QueryProtocol<T> partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    @Override
    public QueryResult<T> execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Sending query of namespace %s on connection [%s] to server %s", this.namespace, connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        QueryResult<T> queryResult = this.receiveMessage(connection, this.sendMessage(connection));
        LOGGER.debug("Query completed");
        return queryResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, SingleResultCallback<QueryResult<T>> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously sending query of namespace %s on connection [%s] to server %s", this.namespace, connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
            QueryMessage message = this.createQueryMessage(connection.getDescription());
            ProtocolHelper.encodeMessage(message, (BsonOutput)bsonOutput);
            QueryResultCallback<T> receiveCallback = new QueryResultCallback<T>(this.namespace, callback, this.resultDecoder, message.getId(), connection.getDescription().getServerAddress());
            connection.sendMessageAsync(bsonOutput.getByteBuffers(), message.getId(), new SendMessageCallback<QueryResult<T>>(connection, bsonOutput, message.getId(), callback, receiveCallback));
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    private QueryMessage createQueryMessage(ConnectionDescription connectionDescription) {
        return (QueryMessage)new QueryMessage(this.namespace.getFullName(), this.skip, this.numberToReturn, this.queryDocument, this.fields, ProtocolHelper.getMessageSettings(connectionDescription)).tailableCursor(this.isTailableCursor()).slaveOk(this.isSlaveOk()).oplogReplay(this.isOplogReplay()).noCursorTimeout(this.isNoCursorTimeout()).awaitData(this.isAwaitData()).partial(this.isPartial());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryMessage sendMessage(InternalConnection connection) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(connection);
        try {
            QueryMessage message = this.createQueryMessage(connection.getDescription());
            message.encode((BsonOutput)bsonOutput);
            connection.sendMessage(bsonOutput.getByteBuffers(), message.getId());
            QueryMessage queryMessage = message;
            return queryMessage;
        }
        finally {
            bsonOutput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult<T> receiveMessage(InternalConnection connection, QueryMessage message) {
        ResponseBuffers responseBuffers = connection.receiveMessage(message.getId());
        try {
            if (responseBuffers.getReplyHeader().isQueryFailure()) {
                BsonDocument errorDocument = (BsonDocument)new ReplyMessage(responseBuffers, new BsonDocumentCodec(), message.getId()).getDocuments().get(0);
                throw ProtocolHelper.getQueryFailureException(errorDocument, connection.getDescription().getServerAddress());
            }
            ReplyMessage<T> replyMessage = new ReplyMessage<T>(responseBuffers, this.resultDecoder, message.getId());
            QueryResult<T> queryResult = new QueryResult<T>(this.namespace, replyMessage, connection.getDescription().getServerAddress());
            return queryResult;
        }
        finally {
            responseBuffers.close();
        }
    }
}

