/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDocumentWriter;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonRegularExpression;
import org.bson.BsonString;
import org.bson.BsonType;
import org.bson.BsonValue;
import org.bson.BsonWriter;
import org.bson.codecs.EncoderContext;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

public final class Filters {
    private Filters() {
    }

    public static <TItem> Bson eq(String fieldName, TItem value) {
        return new SimpleEncodingFilter<TItem>(fieldName, value);
    }

    public static <TItem> Bson ne(String fieldName, TItem value) {
        return new OperatorFilter<TItem>("$ne", fieldName, value);
    }

    public static <TItem> Bson gt(String fieldName, TItem value) {
        return new OperatorFilter<TItem>("$gt", fieldName, value);
    }

    public static <TItem> Bson lt(String fieldName, TItem value) {
        return new OperatorFilter<TItem>("$lt", fieldName, value);
    }

    public static <TItem> Bson gte(String fieldName, TItem value) {
        return new OperatorFilter<TItem>("$gte", fieldName, value);
    }

    public static <TItem> Bson lte(String fieldName, TItem value) {
        return new OperatorFilter<TItem>("$lte", fieldName, value);
    }

    public static <TItem> Bson in(String fieldName, TItem ... values) {
        return Filters.in(fieldName, Arrays.asList(values));
    }

    public static <TItem> Bson in(String fieldName, Iterable<TItem> values) {
        return new SimpleEncodingFilter<IterableOperatorFilter<TItem>>(fieldName, new IterableOperatorFilter<TItem>("$in", values));
    }

    public static <TItem> Bson nin(String fieldName, TItem ... values) {
        return Filters.nin(fieldName, Arrays.asList(values));
    }

    public static <TItem> Bson nin(String fieldName, Iterable<TItem> values) {
        return new SimpleEncodingFilter<IterableOperatorFilter<TItem>>(fieldName, new IterableOperatorFilter<TItem>("$nin", values));
    }

    public static Bson and(Iterable<Bson> filters) {
        return new AndFilter(filters);
    }

    public static Bson and(Bson ... filters) {
        return Filters.and(Arrays.asList(filters));
    }

    public static Bson or(Iterable<Bson> filters) {
        return new OrFilter(filters);
    }

    public static Bson or(Bson ... filters) {
        return Filters.or(Arrays.asList(filters));
    }

    public static Bson not(Bson filter) {
        return new NotFilter(filter);
    }

    public static Bson nor(Bson ... filters) {
        return Filters.nor(Arrays.asList(filters));
    }

    public static Bson nor(Iterable<Bson> filters) {
        return new IterableOperatorFilter<Bson>("$nor", filters);
    }

    public static Bson exists(String fieldName) {
        return Filters.exists(fieldName, true);
    }

    public static Bson exists(String fieldName, boolean exists) {
        return new OperatorFilter<BsonBoolean>("$exists", fieldName, BsonBoolean.valueOf((boolean)exists));
    }

    public static Bson type(String fieldName, BsonType type) {
        return new OperatorFilter<BsonInt32>("$type", fieldName, new BsonInt32(type.getValue()));
    }

    public static Bson mod(String fieldName, long divisor, long remainder) {
        return new OperatorFilter<BsonArray>("$mod", fieldName, new BsonArray(Arrays.asList(new BsonInt64(divisor), new BsonInt64(remainder))));
    }

    public static Bson regex(String fieldName, String pattern) {
        return Filters.regex(fieldName, pattern, null);
    }

    public static Bson regex(String fieldName, String pattern, String options) {
        Assertions.notNull("pattern", pattern);
        return new SimpleFilter(fieldName, (BsonValue)new BsonRegularExpression(pattern, options));
    }

    public static Bson regex(String fieldName, Pattern pattern) {
        Assertions.notNull("pattern", pattern);
        return new SimpleEncodingFilter<Pattern>(fieldName, pattern);
    }

    public static Bson text(String search) {
        Assertions.notNull("search", search);
        return Filters.text(search, null);
    }

    public static Bson text(final String search, final String language) {
        Assertions.notNull("search", search);
        return new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                BsonDocument searchDocument = new BsonDocument("$search", (BsonValue)new BsonString(search));
                if (language != null) {
                    searchDocument.put("$language", (BsonValue)new BsonString(language));
                }
                return new BsonDocument("$text", (BsonValue)searchDocument);
            }
        };
    }

    public static Bson where(String javaScriptExpression) {
        Assertions.notNull("javaScriptExpression", javaScriptExpression);
        return new BsonDocument("$where", (BsonValue)new BsonString(javaScriptExpression));
    }

    public static <TItem> Bson all(String fieldName, TItem ... values) {
        return Filters.all(fieldName, Arrays.asList(values));
    }

    public static <TItem> Bson all(String fieldName, Iterable<TItem> values) {
        return new SimpleEncodingFilter<IterableOperatorFilter<TItem>>(fieldName, new IterableOperatorFilter<TItem>("$all", values));
    }

    public static Bson elemMatch(final String fieldName, final Bson filter) {
        return new Bson(){

            public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
                return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$elemMatch", (BsonValue)filter.toBsonDocument(documentClass, codecRegistry)));
            }
        };
    }

    public static Bson size(String fieldName, int size) {
        return new OperatorFilter<Integer>("$size", fieldName, size);
    }

    private static <TItem> void encodeValue(BsonDocumentWriter writer, TItem value, CodecRegistry codecRegistry) {
        if (value == null) {
            writer.writeNull();
        } else if (value instanceof Bson) {
            codecRegistry.get(BsonDocument.class).encode((BsonWriter)writer, (Object)((Bson)value).toBsonDocument(BsonDocument.class, codecRegistry), EncoderContext.builder().build());
        } else {
            codecRegistry.get(value.getClass()).encode((BsonWriter)writer, value, EncoderContext.builder().build());
        }
    }

    private static class NotFilter
    implements Bson {
        private final Bson filter;

        public NotFilter(Bson filter) {
            this.filter = Assertions.notNull("filter", filter);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument bsonFilter = this.toFilter(this.filter.toBsonDocument(documentClass, codecRegistry));
            if (((String)bsonFilter.keySet().iterator().next()).startsWith("$")) {
                throw new IllegalArgumentException("Invalid $not document, the filter document must start with the field name that the $not operator applies to: " + this.filter);
            }
            return bsonFilter;
        }

        public BsonDocument toFilter(BsonDocument filterDocument) {
            BsonDocument combinedDocument = new BsonDocument();
            for (Map.Entry docs : filterDocument.entrySet()) {
                combinedDocument = this.combineDocuments(combinedDocument, this.createFilter((String)docs.getKey(), (BsonValue)docs.getValue()));
            }
            return combinedDocument;
        }

        private BsonDocument createFilter(String fieldName, BsonValue value) {
            if (fieldName.equals("$and")) {
                return this.toFilter(this.flattenBsonArray(value.asArray()));
            }
            if (value.isDocument() && ((String)((BsonDocument)value).keySet().iterator().next()).startsWith("$")) {
                return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$not", value));
            }
            if (value.isRegularExpression()) {
                return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$not", value));
            }
            return new BsonDocument(fieldName, (BsonValue)new BsonDocument("$not", (BsonValue)new BsonDocument("$eq", value)));
        }

        private BsonDocument combineDocuments(BsonDocument document1, BsonDocument document2) {
            BsonDocument combinedDocument = document1;
            for (Map.Entry entry : document2.entrySet()) {
                String key = (String)entry.getKey();
                BsonValue val = (BsonValue)entry.getValue();
                BsonDocument document = combinedDocument.getDocument((Object)key, new BsonDocument());
                if (!val.isDocument()) {
                    BsonArray inArray;
                    if (document.containsKey((Object)"$in")) {
                        inArray = document.getArray((Object)"$in");
                        inArray.add(val);
                        document.put("$in", (BsonValue)inArray);
                    } else if (document.containsKey((Object)"$eq")) {
                        inArray = document.getArray((Object)"$in", new BsonArray());
                        inArray.add(document.remove((Object)"$eq"));
                        inArray.add(val);
                        document.put("$in", (BsonValue)inArray);
                    } else {
                        document.put("$eq", val);
                    }
                } else {
                    document = val.asDocument();
                }
                combinedDocument.put(key, (BsonValue)document);
            }
            return combinedDocument;
        }

        private BsonDocument flattenBsonArray(BsonArray bsonArray) {
            BsonDocument combinedDocument = new BsonDocument();
            for (BsonValue bsonValue : bsonArray) {
                if (!bsonValue.isDocument()) {
                    throw new IllegalArgumentException("Invalid $not document " + bsonValue);
                }
                combinedDocument = this.combineDocuments(combinedDocument, bsonValue.asDocument());
            }
            return combinedDocument;
        }
    }

    private static class SimpleEncodingFilter<TItem>
    implements Bson {
        private final String fieldName;
        private final TItem value;

        public SimpleEncodingFilter(String fieldName, TItem value) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = value;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            Filters.encodeValue(writer, this.value, codecRegistry);
            writer.writeEndDocument();
            return writer.getDocument();
        }
    }

    private static class IterableOperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final Iterable<TItem> values;

        IterableOperatorFilter(String operatorName, Iterable<TItem> values) {
            this.operatorName = Assertions.notNull("operatorName", operatorName);
            this.values = Assertions.notNull("values", values);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.operatorName);
            writer.writeStartArray();
            for (TItem value : this.values) {
                Filters.encodeValue(writer, value, codecRegistry);
            }
            writer.writeEndArray();
            writer.writeEndDocument();
            return writer.getDocument();
        }
    }

    private static class OrFilter
    implements Bson {
        private final Iterable<Bson> filters;

        public OrFilter(Iterable<Bson> filters) {
            this.filters = Assertions.notNull("filters", filters);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument orRenderable = new BsonDocument();
            BsonArray filtersArray = new BsonArray();
            for (Bson filter : this.filters) {
                filtersArray.add((BsonValue)filter.toBsonDocument(documentClass, codecRegistry));
            }
            orRenderable.put("$or", (BsonValue)filtersArray);
            return orRenderable;
        }
    }

    private static class AndFilter
    implements Bson {
        private final Iterable<Bson> filters;

        public AndFilter(Iterable<Bson> filters) {
            this.filters = Assertions.notNull("filters", filters);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocument andRenderable = new BsonDocument();
            for (Bson filter : this.filters) {
                BsonDocument renderedRenderable = filter.toBsonDocument(documentClass, codecRegistry);
                for (Map.Entry element : renderedRenderable.entrySet()) {
                    this.addClause(andRenderable, element);
                }
            }
            return andRenderable;
        }

        private void addClause(BsonDocument document, Map.Entry<String, BsonValue> clause) {
            if (clause.getKey().equals("$and")) {
                for (BsonValue value : clause.getValue().asArray()) {
                    for (Map.Entry element : value.asDocument().entrySet()) {
                        this.addClause(document, element);
                    }
                }
            } else if (document.size() == 1 && ((String)document.keySet().iterator().next()).equals("$and")) {
                document.get((Object)"$and").asArray().add((BsonValue)new BsonDocument(clause.getKey(), clause.getValue()));
            } else if (document.containsKey((Object)clause.getKey())) {
                if (document.get((Object)clause.getKey()).isDocument() && clause.getValue().isDocument()) {
                    BsonDocument existingClauseValue = document.get((Object)clause.getKey()).asDocument();
                    BsonDocument clauseValue = clause.getValue().asDocument();
                    if (this.keysIntersect(clauseValue, existingClauseValue)) {
                        this.promoteRenderableToDollarForm(document, clause);
                    } else {
                        existingClauseValue.putAll((Map)clauseValue);
                    }
                } else {
                    this.promoteRenderableToDollarForm(document, clause);
                }
            } else {
                document.append(clause.getKey(), clause.getValue());
            }
        }

        private boolean keysIntersect(BsonDocument first, BsonDocument second) {
            for (String name : first.keySet()) {
                if (!second.containsKey((Object)name)) continue;
                return true;
            }
            return false;
        }

        private void promoteRenderableToDollarForm(BsonDocument document, Map.Entry<String, BsonValue> clause) {
            BsonArray clauses = new BsonArray();
            for (Map.Entry queryElement : document.entrySet()) {
                clauses.add((BsonValue)new BsonDocument((String)queryElement.getKey(), (BsonValue)queryElement.getValue()));
            }
            clauses.add((BsonValue)new BsonDocument(clause.getKey(), clause.getValue()));
            document.clear();
            document.put("$and", (BsonValue)clauses);
        }
    }

    private static final class OperatorFilter<TItem>
    implements Bson {
        private final String operatorName;
        private final String fieldName;
        private final TItem value;

        OperatorFilter(String operatorName, String fieldName, TItem value) {
            this.operatorName = Assertions.notNull("operatorName", operatorName);
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = value;
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeName(this.fieldName);
            writer.writeStartDocument();
            writer.writeName(this.operatorName);
            Filters.encodeValue(writer, this.value, codecRegistry);
            writer.writeEndDocument();
            writer.writeEndDocument();
            return writer.getDocument();
        }
    }

    private static final class SimpleFilter
    implements Bson {
        private final String fieldName;
        private final BsonValue value;

        private SimpleFilter(String fieldName, BsonValue value) {
            this.fieldName = Assertions.notNull("fieldName", fieldName);
            this.value = Assertions.notNull("value", value);
        }

        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> documentClass, CodecRegistry codecRegistry) {
            return new BsonDocument(this.fieldName, this.value);
        }
    }
}

