/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.DuplicateKeyException;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoCommandException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.bulk.IndexRequest;
import com.mongodb.bulk.InsertRequest;
import com.mongodb.connection.Connection;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.operation.CommandOperationHelper;
import com.mongodb.operation.OperationHelper;
import com.mongodb.operation.WriteOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDocument;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonString;
import org.bson.BsonValue;

public class CreateIndexesOperation
implements AsyncWriteOperation<Void>,
WriteOperation<Void> {
    private final MongoNamespace namespace;
    private final List<IndexRequest> requests;
    private final MongoNamespace systemIndexes;

    public CreateIndexesOperation(MongoNamespace namespace, List<IndexRequest> requests) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.systemIndexes = new MongoNamespace(namespace.getDatabaseName(), "system.indexes");
        this.requests = Assertions.notNull("indexRequests", requests);
    }

    public List<IndexRequest> getRequests() {
        return this.requests;
    }

    @Override
    public Void execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Void>(){

            @Override
            public Void call(Connection connection) {
                if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection)) {
                    try {
                        CommandOperationHelper.executeWrappedCommandProtocol(CreateIndexesOperation.this.namespace.getDatabaseName(), CreateIndexesOperation.this.getCommand(), connection);
                    }
                    catch (MongoCommandException e) {
                        throw CreateIndexesOperation.this.checkForDuplicateKeyError(e);
                    }
                } else {
                    if (CreateIndexesOperation.this.requests.size() > 1) {
                        throw new MongoInternalException("Creation of multiple indexes simultaneously not supported until MongoDB 2.6");
                    }
                    connection.insert(CreateIndexesOperation.this.systemIndexes, true, WriteConcern.ACKNOWLEDGED, Arrays.asList(new InsertRequest(CreateIndexesOperation.this.getIndex((IndexRequest)CreateIndexesOperation.this.requests.get(0)))));
                }
                return null;
            }
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<Void> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(Connection connection, Throwable t) {
                if (t != null) {
                    ErrorHandlingResultCallback.errorHandlingCallback(callback).onResult(null, t);
                } else {
                    final SingleResultCallback<Object> wrappedCallback = OperationHelper.releasingCallback(ErrorHandlingResultCallback.errorHandlingCallback(callback), connection);
                    if (OperationHelper.serverIsAtLeastVersionTwoDotSix(connection)) {
                        CommandOperationHelper.executeWrappedCommandProtocolAsync(CreateIndexesOperation.this.namespace.getDatabaseName(), CreateIndexesOperation.this.getCommand(), connection, new SingleResultCallback<BsonDocument>(){

                            @Override
                            public void onResult(BsonDocument result, Throwable t) {
                                wrappedCallback.onResult(null, CreateIndexesOperation.this.translateException(t));
                            }
                        });
                    } else if (CreateIndexesOperation.this.requests.size() > 1) {
                        wrappedCallback.onResult(null, new MongoInternalException("Creation of multiple indexes simultaneously not supported until MongoDB 2.6"));
                    } else {
                        connection.insertAsync(CreateIndexesOperation.this.systemIndexes, true, WriteConcern.ACKNOWLEDGED, Arrays.asList(new InsertRequest(CreateIndexesOperation.this.getIndex((IndexRequest)CreateIndexesOperation.this.requests.get(0)))), new SingleResultCallback<WriteConcernResult>(){

                            @Override
                            public void onResult(WriteConcernResult result, Throwable t) {
                                wrappedCallback.onResult(null, CreateIndexesOperation.this.translateException(t));
                            }
                        });
                    }
                }
            }
        });
    }

    private BsonDocument getIndex(IndexRequest request) {
        BsonDocument index = new BsonDocument();
        index.append("key", (BsonValue)request.getKeys());
        index.append("name", (BsonValue)new BsonString(request.getName() != null ? request.getName() : this.generateIndexName(request.getKeys())));
        index.append("ns", (BsonValue)new BsonString(this.namespace.getFullName()));
        if (request.isBackground()) {
            index.append("background", (BsonValue)BsonBoolean.TRUE);
        }
        if (request.isUnique()) {
            index.append("unique", (BsonValue)BsonBoolean.TRUE);
        }
        if (request.isSparse()) {
            index.append("sparse", (BsonValue)BsonBoolean.TRUE);
        }
        if (request.getExpireAfter(TimeUnit.SECONDS) != null) {
            index.append("expireAfterSeconds", (BsonValue)new BsonInt64(request.getExpireAfter(TimeUnit.SECONDS).longValue()));
        }
        if (request.getVersion() != null) {
            index.append("v", (BsonValue)new BsonInt32(request.getVersion().intValue()));
        }
        if (request.getWeights() != null) {
            index.append("weights", (BsonValue)request.getWeights());
        }
        if (request.getDefaultLanguage() != null) {
            index.append("default_language", (BsonValue)new BsonString(request.getDefaultLanguage()));
        }
        if (request.getLanguageOverride() != null) {
            index.append("language_override", (BsonValue)new BsonString(request.getLanguageOverride()));
        }
        if (request.getTextVersion() != null) {
            index.append("textIndexVersion", (BsonValue)new BsonInt32(request.getTextVersion().intValue()));
        }
        if (request.getSphereVersion() != null) {
            index.append("2dsphereIndexVersion", (BsonValue)new BsonInt32(request.getSphereVersion().intValue()));
        }
        if (request.getBits() != null) {
            index.append("bits", (BsonValue)new BsonInt32(request.getBits().intValue()));
        }
        if (request.getMin() != null) {
            index.append("min", (BsonValue)new BsonDouble(request.getMin().doubleValue()));
        }
        if (request.getMax() != null) {
            index.append("max", (BsonValue)new BsonDouble(request.getMax().doubleValue()));
        }
        if (request.getBucketSize() != null) {
            index.append("bucketSize", (BsonValue)new BsonDouble(request.getBucketSize().doubleValue()));
        }
        if (request.getDropDups()) {
            index.append("dropDups", (BsonValue)BsonBoolean.TRUE);
        }
        if (request.getStorageEngine() != null) {
            index.append("storageEngine", (BsonValue)request.getStorageEngine());
        }
        return index;
    }

    private BsonDocument getCommand() {
        BsonDocument command = new BsonDocument("createIndexes", (BsonValue)new BsonString(this.namespace.getCollectionName()));
        ArrayList<BsonDocument> values = new ArrayList<BsonDocument>();
        for (IndexRequest request : this.requests) {
            values.add(this.getIndex(request));
        }
        command.put("indexes", (BsonValue)new BsonArray(values));
        return command;
    }

    private MongoException translateException(Throwable t) {
        return t instanceof MongoCommandException ? this.checkForDuplicateKeyError((MongoCommandException)t) : MongoException.fromThrowable(t);
    }

    private MongoException checkForDuplicateKeyError(MongoCommandException e) {
        if (ErrorCategory.fromErrorCode(e.getCode()) == ErrorCategory.DUPLICATE_KEY) {
            return new DuplicateKeyException(e.getResponse(), e.getServerAddress(), WriteConcernResult.acknowledged(0, false, null));
        }
        return e;
    }

    private String generateIndexName(BsonDocument index) {
        StringBuilder indexName = new StringBuilder();
        for (String keyNames : index.keySet()) {
            if (indexName.length() != 0) {
                indexName.append('_');
            }
            indexName.append(keyNames).append('_');
            BsonValue ascOrDescValue = index.get((Object)keyNames);
            if (ascOrDescValue instanceof BsonInt32) {
                indexName.append(((BsonInt32)ascOrDescValue).getValue());
                continue;
            }
            if (!(ascOrDescValue instanceof BsonString)) continue;
            indexName.append(((BsonString)ascOrDescValue).getValue().replace(' ', '_'));
        }
        return indexName.toString();
    }
}

