/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.ServerAddress;
import com.mongodb.assertions.Assertions;
import com.mongodb.connection.BufferProvider;
import com.mongodb.connection.SocketChannelStream;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SocketStream;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.Stream;
import com.mongodb.connection.StreamFactory;
import com.mongodb.internal.connection.PowerOfTwoBufferPool;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;

public class SocketStreamFactory
implements StreamFactory {
    private final SocketSettings settings;
    private final SslSettings sslSettings;
    private final SocketFactory socketFactory;
    private final BufferProvider bufferProvider = new PowerOfTwoBufferPool();

    public SocketStreamFactory(SocketSettings settings, SslSettings sslSettings) {
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = Assertions.notNull("sslSettings", sslSettings);
        this.socketFactory = null;
    }

    public SocketStreamFactory(SocketSettings settings, SocketFactory socketFactory) {
        this.settings = Assertions.notNull("settings", settings);
        this.sslSettings = null;
        this.socketFactory = Assertions.notNull("socketFactory", socketFactory);
    }

    @Override
    public Stream create(ServerAddress serverAddress) {
        Stream stream = this.socketFactory != null ? new SocketStream(serverAddress, this.settings, this.socketFactory, this.bufferProvider) : (this.sslSettings.isEnabled() ? new SocketStream(serverAddress, this.settings, SSLSocketFactory.getDefault(), this.bufferProvider) : (System.getProperty("org.mongodb.useSocket", "false").equals("true") ? new SocketStream(serverAddress, this.settings, SocketFactory.getDefault(), this.bufferProvider) : new SocketChannelStream(serverAddress, this.settings, this.bufferProvider)));
        return stream;
    }
}

