/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.assertions.Assertions;
import java.util.Arrays;
import java.util.List;
import org.bson.conversions.Bson;

public class CreateIndexOptions {
    private static final List<Integer> VALID_TEXT_INDEX_VERSIONS = Arrays.asList(1, 2);
    private static final List<Integer> VALID_SPHERE_INDEX_VERSIONS = Arrays.asList(1, 2);
    private boolean background;
    private boolean unique;
    private String name;
    private boolean sparse;
    private Integer expireAfterSeconds;
    private Integer version;
    private Bson weights;
    private String defaultLanguage;
    private String languageOverride;
    private Integer textIndexVersion;
    private Integer sphereIndexVersion;
    private Integer bits;
    private Double min;
    private Double max;
    private Double bucketSize;

    public boolean isBackground() {
        return this.background;
    }

    public CreateIndexOptions background(boolean background) {
        this.background = background;
        return this;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public CreateIndexOptions unique(boolean unique) {
        this.unique = unique;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public CreateIndexOptions name(String name) {
        this.name = name;
        return this;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public CreateIndexOptions sparse(boolean sparse) {
        this.sparse = sparse;
        return this;
    }

    public Integer getExpireAfterSeconds() {
        return this.expireAfterSeconds;
    }

    public CreateIndexOptions expireAfterSeconds(Integer expireAfterSeconds) {
        this.expireAfterSeconds = expireAfterSeconds;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public CreateIndexOptions version(Integer version) {
        this.version = version;
        return this;
    }

    public Bson getWeights() {
        return this.weights;
    }

    public CreateIndexOptions weights(Bson weights) {
        this.weights = weights;
        return this;
    }

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public CreateIndexOptions defaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
        return this;
    }

    public String getLanguageOverride() {
        return this.languageOverride;
    }

    public CreateIndexOptions languageOverride(String languageOverride) {
        this.languageOverride = languageOverride;
        return this;
    }

    public Integer getTextIndexVersion() {
        return this.textIndexVersion;
    }

    public CreateIndexOptions textIndexVersion(int textIndexVersion) {
        Assertions.isTrueArgument("textIndexVersion must be 1 or 2", VALID_TEXT_INDEX_VERSIONS.contains(textIndexVersion));
        this.textIndexVersion = textIndexVersion;
        return this;
    }

    public Integer getTwoDSphereIndexVersion() {
        return this.sphereIndexVersion;
    }

    public CreateIndexOptions twoDSphereIndexVersion(int sphereIndexVersion) {
        Assertions.isTrueArgument("sphereIndexVersion must be 1 or 2", VALID_SPHERE_INDEX_VERSIONS.contains(sphereIndexVersion));
        this.sphereIndexVersion = sphereIndexVersion;
        return this;
    }

    public Integer getBits() {
        return this.bits;
    }

    public CreateIndexOptions bits(Integer bits) {
        this.bits = bits;
        return this;
    }

    public Double getMin() {
        return this.min;
    }

    public CreateIndexOptions min(Double min) {
        this.min = min;
        return this;
    }

    public Double getMax() {
        return this.max;
    }

    public CreateIndexOptions max(Double max) {
        this.max = max;
        return this;
    }

    public Double getBucketSize() {
        return this.bucketSize;
    }

    public CreateIndexOptions bucketSize(Double bucketSize) {
        this.bucketSize = bucketSize;
        return this;
    }
}

