/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.model;

import com.mongodb.CursorType;
import com.mongodb.assertions.Assertions;
import java.util.concurrent.TimeUnit;

public final class FindOptions {
    private int batchSize;
    private int limit;
    private Object modifiers;
    private Object projection;
    private long maxTimeMS;
    private int skip;
    private Object sort;
    private CursorType cursorType = CursorType.NonTailable;
    private boolean noCursorTimeout;
    private boolean oplogReplay;
    private boolean partial;

    public FindOptions() {
    }

    public FindOptions(FindOptions from) {
        this.batchSize = from.batchSize;
        this.limit = from.limit;
        this.modifiers = from.modifiers;
        this.projection = from.projection;
        this.maxTimeMS = from.maxTimeMS;
        this.skip = from.skip;
        this.sort = from.sort;
        this.cursorType = from.cursorType;
        this.noCursorTimeout = from.noCursorTimeout;
        this.oplogReplay = from.oplogReplay;
        this.partial = from.partial;
    }

    public int getLimit() {
        return this.limit;
    }

    public FindOptions limit(int limit) {
        this.limit = limit;
        return this;
    }

    public int getSkip() {
        return this.skip;
    }

    public FindOptions skip(int skip) {
        this.skip = skip;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindOptions maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public FindOptions batchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    public Object getModifiers() {
        return this.modifiers;
    }

    public FindOptions modifiers(Object modifiers) {
        this.modifiers = modifiers;
        return this;
    }

    public Object getProjection() {
        return this.projection;
    }

    public FindOptions projection(Object projection) {
        this.projection = projection;
        return this;
    }

    public Object getSort() {
        return this.sort;
    }

    public FindOptions sort(Object sort) {
        this.sort = sort;
        return this;
    }

    public boolean isNoCursorTimeout() {
        return this.noCursorTimeout;
    }

    public FindOptions noCursorTimeout(boolean noCursorTimeout) {
        this.noCursorTimeout = noCursorTimeout;
        return this;
    }

    public boolean isOplogReplay() {
        return this.oplogReplay;
    }

    public FindOptions oplogReplay(boolean oplogReplay) {
        this.oplogReplay = oplogReplay;
        return this;
    }

    public boolean isPartial() {
        return this.partial;
    }

    public FindOptions partial(boolean partial) {
        this.partial = partial;
        return this;
    }

    public CursorType getCursorType() {
        return this.cursorType;
    }

    public FindOptions cursorType(CursorType cursorType) {
        this.cursorType = Assertions.notNull("cursorType", cursorType);
        return this;
    }

    public String toString() {
        return "FindOptions{, batchSize=" + this.batchSize + ", limit=" + this.limit + ", modifiers=" + this.modifiers + ", projection=" + this.projection + ", maxTimeMS=" + this.maxTimeMS + ", skip=" + this.skip + ", sort=" + this.sort + ", cursorType=" + (Object)((Object)this.cursorType) + ", noCursorTimeout=" + this.noCursorTimeout + ", oplogReplay=" + this.oplogReplay + ", partial=" + this.partial + '}';
    }
}

