/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.ServerAddress;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.ErrorHandlingResultCallback;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.connection.Connection;
import com.mongodb.connection.QueryResult;
import com.mongodb.connection.ServerVersion;
import com.mongodb.operation.AsyncQueryBatchCursor;
import com.mongodb.operation.BatchCursor;
import com.mongodb.operation.BsonDocumentWrapperHelper;
import com.mongodb.operation.QueryBatchCursor;
import java.util.Arrays;
import java.util.Collections;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonInt64;
import org.bson.codecs.Decoder;

final class OperationHelper {
    static <T> QueryBatchCursor<T> createEmptyBatchCursor(MongoNamespace namespace, Decoder<T> decoder, ServerAddress serverAddress, int batchSize) {
        return new QueryBatchCursor(new QueryResult(namespace, Collections.emptyList(), 0L, serverAddress), 0, batchSize, decoder, serverAddress);
    }

    static <T> AsyncBatchCursor<T> createEmptyAsyncBatchCursor(MongoNamespace namespace, Decoder<T> decoder, ServerAddress serverAddress, int batchSize) {
        return new AsyncQueryBatchCursor(new QueryResult(namespace, Collections.emptyList(), 0L, serverAddress), 0, batchSize, decoder);
    }

    static <T> BatchCursor<T> cursorDocumentToBatchCursor(BsonDocument cursorDocument, Decoder<T> decoder, ConnectionSource source, int batchSize) {
        return new QueryBatchCursor<T>(OperationHelper.cursorDocumentToQueryResult(cursorDocument, source.getServerDescription().getAddress()), 0, batchSize, decoder, source);
    }

    static <T> AsyncBatchCursor<T> cursorDocumentToAsyncBatchCursor(BsonDocument cursorDocument, Decoder<T> decoder, AsyncConnectionSource source, int batchSize) {
        return new AsyncQueryBatchCursor<T>(OperationHelper.cursorDocumentToQueryResult(cursorDocument, source.getServerDescription().getAddress()), 0, batchSize, decoder, source);
    }

    static <T> QueryResult<T> cursorDocumentToQueryResult(BsonDocument cursorDocument, ServerAddress serverAddress) {
        long cursorId = ((BsonInt64)cursorDocument.get((Object)"id")).getValue();
        MongoNamespace queryResultNamespace = new MongoNamespace(cursorDocument.getString((Object)"ns").getValue());
        BsonArray results = cursorDocument.getArray((Object)"firstBatch");
        return new QueryResult(queryResultNamespace, BsonDocumentWrapperHelper.toList(results), cursorId, serverAddress);
    }

    static <T> SingleResultCallback<T> releasingCallback(SingleResultCallback<T> wrapped, Connection connection) {
        return new ConnectionReleasingWrappedCallback<T>(wrapped, null, connection);
    }

    static <T> SingleResultCallback<T> releasingCallback(SingleResultCallback<T> wrapped, AsyncConnectionSource source, Connection connection) {
        return new ConnectionReleasingWrappedCallback<T>(wrapped, source, connection);
    }

    static boolean serverIsAtLeastVersionTwoDotSix(Connection connection) {
        return OperationHelper.serverIsAtLeastVersion(connection, new ServerVersion(2, 6));
    }

    static boolean serverIsAtLeastVersionTwoDotEight(Connection connection) {
        return OperationHelper.serverIsAtLeastVersion(connection, new ServerVersion(Arrays.asList(2, 8, 0)));
    }

    static boolean serverIsAtLeastVersion(Connection connection, ServerVersion serverVersion) {
        return connection.getDescription().getServerVersion().compareTo(serverVersion) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnection(ReadBinding binding, CallableWithConnection<T> callable) {
        ConnectionSource source = binding.getReadConnectionSource();
        try {
            T t = OperationHelper.withConnectionSource(source, callable);
            return t;
        }
        finally {
            source.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnection(ReadBinding binding, CallableWithConnectionAndSource<T> callable) {
        ConnectionSource source = binding.getReadConnectionSource();
        try {
            T t = OperationHelper.withConnectionSource(source, callable);
            return t;
        }
        finally {
            source.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnection(WriteBinding binding, CallableWithConnection<T> callable) {
        ConnectionSource source = binding.getWriteConnectionSource();
        try {
            T t = OperationHelper.withConnectionSource(source, callable);
            return t;
        }
        finally {
            source.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnectionSource(ConnectionSource source, CallableWithConnection<T> callable) {
        Connection connection = source.getConnection();
        try {
            T t = callable.call(connection);
            return t;
        }
        finally {
            connection.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T withConnectionSource(ConnectionSource source, CallableWithConnectionAndSource<T> callable) {
        Connection connection = source.getConnection();
        try {
            T t = callable.call(source, connection);
            return t;
        }
        finally {
            connection.release();
        }
    }

    static void withConnection(AsyncWriteBinding binding, AsyncCallableWithConnection callable) {
        binding.getWriteConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithConnectionCallback(callable)));
    }

    static void withConnection(AsyncReadBinding binding, AsyncCallableWithConnection callable) {
        binding.getReadConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithConnectionCallback(callable)));
    }

    static void withConnection(AsyncReadBinding binding, AsyncCallableWithConnectionAndSource callable) {
        binding.getReadConnectionSource(ErrorHandlingResultCallback.errorHandlingCallback(new AsyncCallableWithConnectionAndSourceCallback(callable)));
    }

    private static <T> void withConnectionSource(final AsyncConnectionSource source, final AsyncCallableWithConnection callable) {
        source.getConnection(new SingleResultCallback<Connection>(){

            @Override
            public void onResult(Connection connection, Throwable t) {
                source.release();
                if (t != null) {
                    callable.call(null, t);
                } else {
                    callable.call(connection, null);
                }
            }
        });
    }

    private static <T> void withConnectionSource(final AsyncConnectionSource source, final AsyncCallableWithConnectionAndSource callable) {
        source.getConnection(new SingleResultCallback<Connection>(){

            @Override
            public void onResult(Connection result, Throwable t) {
                callable.call(source, result, t);
            }
        });
    }

    private OperationHelper() {
    }

    private static class AsyncCallableWithConnectionAndSourceCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithConnectionAndSource callable;

        public AsyncCallableWithConnectionAndSourceCallback(AsyncCallableWithConnectionAndSource callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(AsyncConnectionSource source, Throwable t) {
            if (t != null) {
                this.callable.call(null, null, t);
            } else {
                OperationHelper.withConnectionSource(source, this.callable);
            }
        }
    }

    private static class AsyncCallableWithConnectionCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final AsyncCallableWithConnection callable;

        public AsyncCallableWithConnectionCallback(AsyncCallableWithConnection callable) {
            this.callable = callable;
        }

        @Override
        public void onResult(AsyncConnectionSource source, Throwable t) {
            if (t != null) {
                this.callable.call(null, t);
            } else {
                OperationHelper.withConnectionSource(source, this.callable);
            }
        }
    }

    private static class ConnectionReleasingWrappedCallback<T>
    implements SingleResultCallback<T> {
        private final SingleResultCallback<T> wrapped;
        private final AsyncConnectionSource source;
        private final Connection connection;

        ConnectionReleasingWrappedCallback(SingleResultCallback<T> wrapped, AsyncConnectionSource source, Connection connection) {
            this.wrapped = wrapped;
            this.source = source;
            this.connection = connection;
        }

        @Override
        public void onResult(T result, Throwable t) {
            if (this.connection != null) {
                this.connection.release();
            }
            if (this.source != null) {
                this.source.release();
            }
            this.wrapped.onResult(result, t);
        }
    }

    static class VoidTransformer<T>
    implements Function<T, Void> {
        VoidTransformer() {
        }

        @Override
        public Void apply(T t) {
            return null;
        }
    }

    static class IdentityTransformer<T>
    implements Function<T, T> {
        IdentityTransformer() {
        }

        @Override
        public T apply(T t) {
            return t;
        }
    }

    static interface AsyncCallableWithConnectionAndSource {
        public void call(AsyncConnectionSource var1, Connection var2, Throwable var3);
    }

    static interface AsyncCallableWithConnection {
        public void call(Connection var1, Throwable var2);
    }

    static interface CallableWithConnectionAndSource<T> {
        public T call(ConnectionSource var1, Connection var2);
    }

    static interface CallableWithConnection<T> {
        public T call(Connection var1);
    }
}

