/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.Function;
import com.mongodb.MongoCommandException;
import com.mongodb.ReadPreference;
import com.mongodb.async.ErrorHandlingResultCallback;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.binding.ConnectionSource;
import com.mongodb.binding.ReadBinding;
import com.mongodb.binding.WriteBinding;
import com.mongodb.connection.Connection;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ServerType;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.operation.OperationHelper;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.FieldNameValidator;
import org.bson.codecs.BsonDocumentCodec;
import org.bson.codecs.Decoder;

final class CommandOperationHelper {
    static BsonDocument executeWrappedCommandProtocol(String database, BsonDocument command, ReadBinding binding) {
        return (BsonDocument)CommandOperationHelper.executeWrappedCommandProtocol(database, command, new BsonDocumentCodec(), binding);
    }

    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, ReadBinding binding, Function<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, new BsonDocumentCodec(), binding, transformer);
    }

    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<T> decoder, ReadBinding binding) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, decoder, binding, new OperationHelper.IdentityTransformer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <D, T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<D> decoder, ReadBinding binding, Function<D, T> transformer) {
        ConnectionSource source = binding.getReadConnectionSource();
        try {
            T t = transformer.apply(CommandOperationHelper.executeWrappedCommandProtocol(database, command, decoder, source, binding.getReadPreference()));
            return t;
        }
        finally {
            source.release();
        }
    }

    static BsonDocument executeWrappedCommandProtocol(String database, BsonDocument command, WriteBinding binding) {
        return (BsonDocument)CommandOperationHelper.executeWrappedCommandProtocol(database, command, binding, new OperationHelper.IdentityTransformer());
    }

    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<T> decoder, WriteBinding binding) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, decoder, binding, new OperationHelper.IdentityTransformer());
    }

    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, WriteBinding binding, Function<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, new BsonDocumentCodec(), binding, transformer);
    }

    static <D, T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<D> decoder, WriteBinding binding, Function<D, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, (FieldNameValidator)new NoOpFieldNameValidator(), decoder, binding, transformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <D, T> T executeWrappedCommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, WriteBinding binding, Function<D, T> transformer) {
        ConnectionSource source = binding.getWriteConnectionSource();
        try {
            T t = transformer.apply(CommandOperationHelper.executeWrappedCommandProtocol(database, command, fieldNameValidator, decoder, source, ReadPreference.primary()));
            return t;
        }
        finally {
            source.release();
        }
    }

    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<T> decoder, ConnectionSource source, ReadPreference readPreference) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, (FieldNameValidator)new NoOpFieldNameValidator(), decoder, source, readPreference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<T> decoder, ConnectionSource source, ReadPreference readPreference) {
        Connection connection = source.getConnection();
        try {
            T t = CommandOperationHelper.executeWrappedCommandProtocol(database, command, fieldNameValidator, decoder, connection, readPreference);
            return t;
        }
        finally {
            connection.release();
        }
    }

    static BsonDocument executeWrappedCommandProtocol(String database, BsonDocument command, Connection connection) {
        return (BsonDocument)CommandOperationHelper.executeWrappedCommandProtocol(database, command, new BsonDocumentCodec(), connection, ReadPreference.primary());
    }

    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<T> decoder, Connection connection, ReadPreference readPreference) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, (FieldNameValidator)new NoOpFieldNameValidator(), decoder, connection, readPreference);
    }

    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<BsonDocument> decoder, Connection connection, Function<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, decoder, connection, ReadPreference.primary(), transformer);
    }

    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, Connection connection, ReadPreference readPreference, Function<BsonDocument, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, new BsonDocumentCodec(), connection, readPreference, transformer);
    }

    static <D, T> T executeWrappedCommandProtocol(String database, BsonDocument command, Decoder<D> decoder, Connection connection, ReadPreference readPreference, Function<D, T> transformer) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, new NoOpFieldNameValidator(), decoder, connection, readPreference, transformer);
    }

    static <T> T executeWrappedCommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<T> decoder, Connection connection, ReadPreference readPreference) {
        return CommandOperationHelper.executeWrappedCommandProtocol(database, command, fieldNameValidator, decoder, connection, readPreference, new OperationHelper.IdentityTransformer());
    }

    static <D, T> T executeWrappedCommandProtocol(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, Connection connection, ReadPreference readPreference, Function<D, T> transformer) {
        return transformer.apply(connection.command(database, CommandOperationHelper.wrapCommand(command, readPreference, connection.getDescription()), readPreference.isSlaveOk(), fieldNameValidator, decoder));
    }

    static void executeWrappedCommandProtocolAsync(String database, BsonDocument command, AsyncReadBinding binding, SingleResultCallback<BsonDocument> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, new BsonDocumentCodec(), binding, callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, Decoder<T> decoder, AsyncReadBinding binding, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, decoder, binding, new OperationHelper.IdentityTransformer(), callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, AsyncReadBinding binding, Function<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, new BsonDocumentCodec(), binding, transformer, callback);
    }

    static <D, T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, Decoder<D> decoder, AsyncReadBinding binding, Function<D, T> transformer, SingleResultCallback<T> callback) {
        binding.getReadConnectionSource(new CommandProtocolExecutingCallback<D, T>(database, command, new NoOpFieldNameValidator(), decoder, ReadPreference.primary(), transformer, ErrorHandlingResultCallback.errorHandlingCallback(callback)));
    }

    static void executeWrappedCommandProtocolAsync(String database, BsonDocument command, AsyncWriteBinding binding, SingleResultCallback<BsonDocument> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, new BsonDocumentCodec(), binding, callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, Decoder<T> decoder, AsyncWriteBinding binding, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, decoder, binding, new OperationHelper.IdentityTransformer(), callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, AsyncWriteBinding binding, Function<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, new BsonDocumentCodec(), binding, transformer, callback);
    }

    static <D, T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, Decoder<D> decoder, AsyncWriteBinding binding, Function<D, T> transformer, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, new NoOpFieldNameValidator(), decoder, binding, transformer, callback);
    }

    static <D, T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, AsyncWriteBinding binding, Function<D, T> transformer, SingleResultCallback<T> callback) {
        binding.getWriteConnectionSource(new CommandProtocolExecutingCallback<D, T>(database, command, fieldNameValidator, decoder, ReadPreference.primary(), transformer, ErrorHandlingResultCallback.errorHandlingCallback(callback)));
    }

    static void executeWrappedCommandProtocolAsync(String database, BsonDocument command, Connection connection, SingleResultCallback<BsonDocument> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, new BsonDocumentCodec(), connection, callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, Connection connection, Function<BsonDocument, T> transformer, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, new BsonDocumentCodec(), connection, ReadPreference.primary(), transformer, callback);
    }

    static <T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, Decoder<T> decoder, Connection connection, SingleResultCallback<T> callback) {
        CommandOperationHelper.executeWrappedCommandProtocolAsync(database, command, decoder, connection, ReadPreference.primary(), new OperationHelper.IdentityTransformer(), callback);
    }

    static <D, T> void executeWrappedCommandProtocolAsync(String database, BsonDocument command, Decoder<D> decoder, Connection connection, ReadPreference readPreference, final Function<D, T> transformer, final SingleResultCallback<T> callback) {
        connection.commandAsync(database, CommandOperationHelper.wrapCommand(command, readPreference, connection.getDescription()), readPreference.isSlaveOk(), new NoOpFieldNameValidator(), decoder, new SingleResultCallback<D>(){

            @Override
            public void onResult(D result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    try {
                        Object transformedResult = transformer.apply(result);
                        callback.onResult(transformedResult, null);
                    }
                    catch (Exception e) {
                        callback.onResult(null, e);
                    }
                }
            }
        });
    }

    static void rethrowIfNotNamespaceError(MongoCommandException e) {
        CommandOperationHelper.rethrowIfNotNamespaceError(e, null);
    }

    static <T> T rethrowIfNotNamespaceError(MongoCommandException e, T defaultValue) {
        if (!CommandOperationHelper.isNamespaceError(e)) {
            throw e;
        }
        return defaultValue;
    }

    static boolean isNamespaceError(Throwable t) {
        if (t instanceof MongoCommandException) {
            MongoCommandException e = (MongoCommandException)t;
            return e.getErrorMessage().contains("ns not found") || e.getErrorCode() == 26;
        }
        return false;
    }

    static BsonDocument wrapCommand(BsonDocument command, ReadPreference readPreference, ConnectionDescription connectionDescription) {
        if (connectionDescription.getServerType() == ServerType.SHARD_ROUTER && !readPreference.equals(ReadPreference.primary())) {
            return new BsonDocument("$query", (BsonValue)command).append("$readPreference", (BsonValue)readPreference.toDocument());
        }
        return command;
    }

    private CommandOperationHelper() {
    }

    private static class CommandProtocolExecutingCallback<D, R>
    implements SingleResultCallback<AsyncConnectionSource> {
        private final String database;
        private final BsonDocument command;
        private final Decoder<D> decoder;
        private final ReadPreference readPreference;
        private final FieldNameValidator fieldNameValidator;
        private final Function<D, R> transformer;
        private final SingleResultCallback<R> callback;

        public CommandProtocolExecutingCallback(String database, BsonDocument command, FieldNameValidator fieldNameValidator, Decoder<D> decoder, ReadPreference readPreference, Function<D, R> transformer, SingleResultCallback<R> callback) {
            this.database = database;
            this.command = command;
            this.fieldNameValidator = fieldNameValidator;
            this.decoder = decoder;
            this.readPreference = readPreference;
            this.transformer = transformer;
            this.callback = callback;
        }

        @Override
        public void onResult(final AsyncConnectionSource source, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                source.getConnection(new SingleResultCallback<Connection>(){

                    @Override
                    public void onResult(Connection connection, Throwable t) {
                        if (t != null) {
                            CommandProtocolExecutingCallback.this.callback.onResult(null, t);
                        } else {
                            final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(CommandProtocolExecutingCallback.this.callback, source, connection);
                            connection.commandAsync(CommandProtocolExecutingCallback.this.database, CommandOperationHelper.wrapCommand(CommandProtocolExecutingCallback.this.command, CommandProtocolExecutingCallback.this.readPreference, connection.getDescription()), CommandProtocolExecutingCallback.this.readPreference.isSlaveOk(), CommandProtocolExecutingCallback.this.fieldNameValidator, CommandProtocolExecutingCallback.this.decoder, new SingleResultCallback<D>(){

                                @Override
                                public void onResult(D response, Throwable t) {
                                    if (t != null) {
                                        wrappedCallback.onResult(null, t);
                                    } else {
                                        wrappedCallback.onResult(CommandProtocolExecutingCallback.this.transformer.apply(response), null);
                                    }
                                }
                            });
                        }
                    }
                });
            }
        }
    }
}

