/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSessionBinding;
import com.mongodb.async.client.ClientSessionHelper;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.binding.AsyncClusterBinding;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.session.ClientSession;

class AsyncOperationExecutorImpl
implements AsyncOperationExecutor {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final MongoClientImpl mongoClient;
    private final ClientSessionHelper clientSessionHelper;

    AsyncOperationExecutorImpl(MongoClientImpl mongoClient, ClientSessionHelper clientSessionHelper) {
        this.mongoClient = mongoClient;
        this.clientSessionHelper = clientSessionHelper;
    }

    public <T> void execute(AsyncReadOperation<T> operation, ReadPreference readPreference, SingleResultCallback<T> callback) {
        this.execute(operation, readPreference, null, callback);
    }

    public <T> void execute(final AsyncReadOperation<T> operation, final ReadPreference readPreference, final ClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        this.clientSessionHelper.withClientSession(session, new SingleResultCallback<ClientSession>(){

            public void onResult(ClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    AsyncReadWriteBinding binding = AsyncOperationExecutorImpl.this.getReadWriteBinding(readPreference, clientSession, session == null && clientSession != null);
                    operation.executeAsync((AsyncReadBinding)binding, new SingleResultCallback<T>((AsyncReadBinding)binding){
                        final /* synthetic */ AsyncReadBinding val$binding;
                        {
                            this.val$binding = asyncReadBinding;
                        }

                        public void onResult(T result, Throwable t) {
                            try {
                                errHandlingCallback.onResult(result, t);
                            }
                            finally {
                                this.val$binding.release();
                            }
                        }
                    });
                }
            }
        });
    }

    public <T> void execute(AsyncWriteOperation<T> operation, SingleResultCallback<T> callback) {
        this.execute(operation, null, callback);
    }

    public <T> void execute(final AsyncWriteOperation<T> operation, final @Nullable ClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        this.clientSessionHelper.withClientSession(session, new SingleResultCallback<ClientSession>(){

            public void onResult(ClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    AsyncReadWriteBinding binding = AsyncOperationExecutorImpl.this.getReadWriteBinding(ReadPreference.primary(), clientSession, session == null && clientSession != null);
                    operation.executeAsync((AsyncWriteBinding)binding, new SingleResultCallback<T>((AsyncWriteBinding)binding){
                        final /* synthetic */ AsyncWriteBinding val$binding;
                        {
                            this.val$binding = asyncWriteBinding;
                        }

                        public void onResult(T result, Throwable t) {
                            try {
                                errHandlingCallback.onResult(result, t);
                            }
                            finally {
                                this.val$binding.release();
                            }
                        }
                    });
                }
            }
        });
    }

    private AsyncReadWriteBinding getReadWriteBinding(ReadPreference readPreference, @Nullable ClientSession session, boolean ownsSession) {
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        Object readWriteBinding = new AsyncClusterBinding(this.mongoClient.getCluster(), readPreference);
        if (session != null) {
            readWriteBinding = new ClientSessionBinding(session, ownsSession, (AsyncReadWriteBinding)readWriteBinding);
        }
        return readWriteBinding;
    }
}

