/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MappingAsyncBatchCursor;
import com.mongodb.async.client.MongoIterable;
import java.util.Collection;
import org.bson.assertions.Assertions;

class MappingIterable<T, U>
implements MongoIterable<U> {
    private final MongoIterable<T> iterable;
    private final Function<T, U> mapper;

    MappingIterable(MongoIterable<T> iterable, Function<T, U> mapper) {
        this.iterable = (MongoIterable)Assertions.notNull((String)"iterable", iterable);
        this.mapper = (Function)Assertions.notNull((String)"mapper", mapper);
    }

    @Override
    public void first(final SingleResultCallback<U> callback) {
        Assertions.notNull((String)"callback", callback);
        this.iterable.first(new SingleResultCallback<T>(){

            public void onResult(T result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(MappingIterable.this.mapper.apply(result), null);
                }
            }
        });
    }

    @Override
    public void forEach(final Block<? super U> block, final SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"block", block);
        Assertions.notNull((String)"callback", callback);
        this.iterable.forEach(new Block<T>(){

            public void apply(T t) {
                block.apply(MappingIterable.this.mapper.apply(t));
            }
        }, new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(null, null);
                }
            }
        });
    }

    @Override
    public <A extends Collection<? super U>> void into(final A target, final SingleResultCallback<A> callback) {
        Assertions.notNull((String)"target", target);
        Assertions.notNull((String)"callback", callback);
        this.iterable.forEach(new Block<T>(){

            public void apply(T t) {
                target.add(MappingIterable.this.mapper.apply(t));
            }
        }, new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)target, null);
                }
            }
        });
    }

    @Override
    public <V> MongoIterable<V> map(Function<U, V> mapper) {
        return new MappingIterable<U, V>(this, mapper);
    }

    @Override
    public MongoIterable<U> batchSize(int batchSize) {
        this.iterable.batchSize(batchSize);
        return this;
    }

    @Override
    public void batchCursor(final SingleResultCallback<AsyncBatchCursor<U>> callback) {
        Assertions.notNull((String)"callback", callback);
        this.iterable.batchCursor(new SingleResultCallback<AsyncBatchCursor<T>>(){

            public void onResult(AsyncBatchCursor<T> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(new MappingAsyncBatchCursor(batchCursor, MappingIterable.this.mapper), null);
                }
            }
        });
    }
}

