/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ConnectionString;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.client.MongoDriverInformation;
import com.mongodb.client.gridfs.codecs.GridFSFileCodecProvider;
import com.mongodb.client.model.geojson.codecs.GeoJsonCodecProvider;
import com.mongodb.connection.AsynchronousSocketChannelStreamFactory;
import com.mongodb.connection.ClusterSettings;
import com.mongodb.connection.ConnectionPoolSettings;
import com.mongodb.connection.DefaultClusterFactory;
import com.mongodb.connection.ServerSettings;
import com.mongodb.connection.SocketSettings;
import com.mongodb.connection.SslSettings;
import com.mongodb.connection.StreamFactory;
import com.mongodb.connection.StreamFactoryFactory;
import com.mongodb.connection.netty.NettyStreamFactory;
import com.mongodb.event.CommandEventMulticaster;
import com.mongodb.event.CommandListener;
import com.mongodb.event.ConnectionPoolListener;
import com.mongodb.management.JMXConnectionPoolListener;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.IterableCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

public final class MongoClients {
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new DocumentCodecProvider(), new BsonValueCodecProvider(), new IterableCodecProvider(), new GeoJsonCodecProvider(), new GridFSFileCodecProvider()));

    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(settings, mongoDriverInformation, null);
    }

    public static MongoClient create(ConnectionString connectionString, MongoDriverInformation mongoDriverInformation) {
        MongoClientSettings.Builder builder = MongoClientSettings.builder().clusterSettings(ClusterSettings.builder().applyConnectionString(connectionString).build()).connectionPoolSettings(ConnectionPoolSettings.builder().applyConnectionString(connectionString).build()).serverSettings(ServerSettings.builder().applyConnectionString(connectionString).build()).credentialList(connectionString.getCredentialList()).sslSettings(SslSettings.builder().applyConnectionString(connectionString).build()).socketSettings(SocketSettings.builder().applyConnectionString(connectionString).build());
        if (connectionString.getReadPreference() != null) {
            builder.readPreference(connectionString.getReadPreference());
        }
        if (connectionString.getReadConcern() != null) {
            builder.readConcern(connectionString.getReadConcern());
        }
        if (connectionString.getWriteConcern() != null) {
            builder.writeConcern(connectionString.getWriteConcern());
        }
        if (connectionString.getApplicationName() != null) {
            builder.applicationName(connectionString.getApplicationName());
        }
        return MongoClients.create(builder.build(), mongoDriverInformation, connectionString.getStreamType());
    }

    private static MongoClient create(MongoClientSettings settings, MongoDriverInformation mongoDriverInformation, String requestedStreamType) {
        String streamType = MongoClients.getStreamType(requestedStreamType);
        EventLoopGroup eventLoopGroup = MongoClients.getEventLoopGroupIfNecessary(settings.getStreamFactoryFactory(), streamType);
        StreamFactory streamFactory = MongoClients.getStreamFactory(settings.getStreamFactoryFactory(), settings.getSocketSettings(), settings.getSslSettings(), streamType, eventLoopGroup);
        StreamFactory heartbeatStreamFactory = MongoClients.getStreamFactory(settings.getStreamFactoryFactory(), settings.getHeartbeatSocketSettings(), settings.getSslSettings(), streamType, eventLoopGroup);
        return new MongoClientImpl(settings, new DefaultClusterFactory().create(settings.getClusterSettings(), settings.getServerSettings(), settings.getConnectionPoolSettings(), streamFactory, heartbeatStreamFactory, settings.getCredentialList(), null, (ConnectionPoolListener)new JMXConnectionPoolListener(), null, MongoClients.createCommandListener(settings.getCommandListeners()), settings.getApplicationName(), mongoDriverInformation), MongoClients.getEventLoopGroupCloser(eventLoopGroup));
    }

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    private static StreamFactory getStreamFactory(StreamFactoryFactory streamFactoryFactory, SocketSettings socketSettings, SslSettings sslSettings, String streamType, EventLoopGroup eventLoopGroup) {
        if (streamFactoryFactory != null) {
            return streamFactoryFactory.create(socketSettings, sslSettings);
        }
        if (MongoClients.isNetty(streamType)) {
            return new NettyStreamFactory(socketSettings, sslSettings, eventLoopGroup);
        }
        if (MongoClients.isNio2(streamType)) {
            return new AsynchronousSocketChannelStreamFactory(socketSettings, sslSettings);
        }
        throw new IllegalArgumentException("Unsupported stream type: " + streamType);
    }

    private static boolean isNetty(String streamType) {
        return streamType.toLowerCase().equals("netty");
    }

    private static boolean isNio2(String streamType) {
        return streamType.toLowerCase().equals("nio2");
    }

    private static String getStreamType(String requestedStreamType) {
        if (requestedStreamType != null) {
            return requestedStreamType;
        }
        return System.getProperty("org.mongodb.async.type", "nio2");
    }

    private static Closeable getEventLoopGroupCloser(final EventLoopGroup eventLoopGroup) {
        if (eventLoopGroup == null) {
            return null;
        }
        return new Closeable(){

            @Override
            public void close() throws IOException {
                eventLoopGroup.shutdownGracefully().awaitUninterruptibly();
            }
        };
    }

    private static EventLoopGroup getEventLoopGroupIfNecessary(StreamFactoryFactory streamFactoryFactory, String streamType) {
        if (MongoClients.isNetty(streamType) && streamFactoryFactory == null) {
            return new NioEventLoopGroup();
        }
        return null;
    }

    private static CommandListener createCommandListener(List<CommandListener> commandListeners) {
        switch (commandListeners.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return commandListeners.get(0);
            }
        }
        return new CommandEventMulticaster(commandListeners);
    }

    private MongoClients() {
    }
}

