/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.Server;
import com.mongodb.connection.ServerDescription;
import com.mongodb.internal.binding.AsyncClusterAwareReadWriteBinding;
import com.mongodb.internal.session.ClientSessionContext;
import com.mongodb.selector.ReadPreferenceServerSelector;
import com.mongodb.selector.ServerSelector;
import com.mongodb.session.SessionContext;

class ClientSessionBinding
implements AsyncReadWriteBinding {
    private final AsyncClusterAwareReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    ClientSessionBinding(ClientSession session, boolean ownsSession, AsyncClusterAwareReadWriteBinding wrapped) {
        this.wrapped = (AsyncClusterAwareReadWriteBinding)Assertions.notNull((String)"wrapped", (Object)wrapped);
        this.ownsSession = ownsSession;
        this.session = (ClientSession)Assertions.notNull((String)"session", (Object)session);
        this.sessionContext = new AsyncClientSessionContext(session);
    }

    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    public void getReadConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.isActiveShardedTxn()) {
            this.getPinnedConnectionSource(callback);
        } else {
            this.wrapped.getReadConnectionSource((SingleResultCallback)new WrappingCallback(callback));
        }
    }

    public void getWriteConnectionSource(SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.isActiveShardedTxn()) {
            this.getPinnedConnectionSource(callback);
        } else {
            this.wrapped.getWriteConnectionSource((SingleResultCallback)new WrappingCallback(callback));
        }
    }

    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    private void getPinnedConnectionSource(final SingleResultCallback<AsyncConnectionSource> callback) {
        if (this.session.getPinnedServerAddress() == null) {
            this.wrapped.getCluster().selectServerAsync((ServerSelector)new ReadPreferenceServerSelector(this.wrapped.getReadPreference()), (SingleResultCallback)new SingleResultCallback<Server>(){

                public void onResult(Server server, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        ClientSessionBinding.this.session.setPinnedServerAddress(server.getDescription().getAddress());
                        ClientSessionBinding.this.wrapped.getConnectionSource(ClientSessionBinding.this.session.getPinnedServerAddress(), (SingleResultCallback)new WrappingCallback((SingleResultCallback<AsyncConnectionSource>)callback));
                    }
                }
            });
        } else {
            this.wrapped.getConnectionSource(this.session.getPinnedServerAddress(), (SingleResultCallback)new WrappingCallback(callback));
        }
    }

    public int getCount() {
        return this.wrapped.getCount();
    }

    public AsyncReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    public void release() {
        this.wrapped.release();
        this.closeSessionIfCountIsZero();
    }

    private void closeSessionIfCountIsZero() {
        if (this.getCount() == 0 && this.ownsSession) {
            this.session.close();
        }
    }

    private boolean isActiveShardedTxn() {
        return this.session.hasActiveTransaction() && this.wrapped.getCluster().getDescription().getType() == ClusterType.SHARDED;
    }

    private class WrappingCallback
    implements SingleResultCallback<AsyncConnectionSource> {
        private final SingleResultCallback<AsyncConnectionSource> callback;

        WrappingCallback(SingleResultCallback<AsyncConnectionSource> callback) {
            this.callback = callback;
        }

        public void onResult(AsyncConnectionSource result, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else {
                this.callback.onResult((Object)new SessionBindingAsyncConnectionSource(result), null);
            }
        }
    }

    private final class AsyncClientSessionContext
    extends ClientSessionContext
    implements SessionContext {
        private final ClientSession clientSession;

        AsyncClientSessionContext(ClientSession clientSession) {
            super((com.mongodb.session.ClientSession)clientSession);
            this.clientSession = clientSession;
        }

        public boolean isImplicitSession() {
            return ClientSessionBinding.this.ownsSession;
        }

        public boolean notifyMessageSent() {
            return this.clientSession.notifyMessageSent();
        }

        public boolean hasActiveTransaction() {
            return this.clientSession.hasActiveTransaction();
        }

        public ReadConcern getReadConcern() {
            if (this.clientSession.hasActiveTransaction()) {
                return this.clientSession.getTransactionOptions().getReadConcern();
            }
            return ClientSessionBinding.this.wrapped.getSessionContext().getReadConcern();
        }
    }

    private class SessionBindingAsyncConnectionSource
    implements AsyncConnectionSource {
        private AsyncConnectionSource wrapped;

        SessionBindingAsyncConnectionSource(AsyncConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        public void getConnection(SingleResultCallback<AsyncConnection> callback) {
            this.wrapped.getConnection(callback);
        }

        public AsyncConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        public int getCount() {
            return this.wrapped.getCount();
        }

        public void release() {
            this.wrapped.release();
            ClientSessionBinding.this.closeSessionIfCountIsZero();
        }
    }
}

