/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoNamespace;
import com.mongodb.MongoWriteConcernException;
import com.mongodb.MongoWriteException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.WriteConcernResult;
import com.mongodb.WriteError;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.AggregateIterableImpl;
import com.mongodb.async.client.ChangeStreamIterable;
import com.mongodb.async.client.ChangeStreamIterableImpl;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.DistinctIterableImpl;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.FindIterableImpl;
import com.mongodb.async.client.ListIndexesIterable;
import com.mongodb.async.client.ListIndexesIterableImpl;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.async.client.MapReduceIterableImpl;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.bulk.BulkWriteUpsert;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.client.model.AggregationLevel;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.DeleteOptions;
import com.mongodb.client.model.DropIndexOptions;
import com.mongodb.client.model.EstimatedDocumentCountOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.IndexModel;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.InsertOneOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.model.changestream.ChangeStreamLevel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.mongodb.internal.client.model.CountOptionsHelper;
import com.mongodb.internal.client.model.CountStrategy;
import com.mongodb.internal.operation.AsyncOperations;
import com.mongodb.internal.operation.IndexHelper;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.AsyncWriteOperation;
import java.util.Collections;
import java.util.List;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

class MongoCollectionImpl<TDocument>
implements MongoCollection<TDocument> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final ReadPreference readPreference;
    private final CodecRegistry codecRegistry;
    private final WriteConcern writeConcern;
    private final boolean retryWrites;
    private final ReadConcern readConcern;
    private final OperationExecutor executor;
    private final AsyncOperations<TDocument> operations;

    MongoCollectionImpl(MongoNamespace namespace, Class<TDocument> documentClass, CodecRegistry codecRegistry, ReadPreference readPreference, WriteConcern writeConcern, boolean retryWrites, ReadConcern readConcern, OperationExecutor executor) {
        this.namespace = (MongoNamespace)Assertions.notNull((String)"namespace", (Object)namespace);
        this.documentClass = (Class)Assertions.notNull((String)"documentClass", documentClass);
        this.codecRegistry = (CodecRegistry)Assertions.notNull((String)"codecRegistry", (Object)codecRegistry);
        this.readPreference = (ReadPreference)Assertions.notNull((String)"readPreference", (Object)readPreference);
        this.writeConcern = (WriteConcern)Assertions.notNull((String)"writeConcern", (Object)writeConcern);
        this.retryWrites = retryWrites;
        this.readConcern = (ReadConcern)Assertions.notNull((String)"readConcern", (Object)readConcern);
        this.executor = (OperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
        this.operations = new AsyncOperations(namespace, documentClass, readPreference, codecRegistry, writeConcern, retryWrites);
    }

    @Override
    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    @Override
    public Class<TDocument> getDocumentClass() {
        return this.documentClass;
    }

    @Override
    public CodecRegistry getCodecRegistry() {
        return this.codecRegistry;
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.readPreference;
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    @Override
    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    @Override
    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> newDocumentClass) {
        return new MongoCollectionImpl<NewTDocument>(this.namespace, newDocumentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry codecRegistry) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadPreference(ReadPreference readPreference) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, readPreference, this.writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withWriteConcern(WriteConcern writeConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, writeConcern, this.retryWrites, this.readConcern, this.executor);
    }

    @Override
    public MongoCollection<TDocument> withReadConcern(ReadConcern readConcern) {
        return new MongoCollectionImpl<TDocument>(this.namespace, this.documentClass, this.codecRegistry, this.readPreference, this.writeConcern, this.retryWrites, readConcern, this.executor);
    }

    @Override
    public void count(SingleResultCallback<Long> callback) {
        this.count((Bson)new BsonDocument(), callback);
    }

    @Override
    public void count(Bson filter, SingleResultCallback<Long> callback) {
        this.count(filter, new CountOptions(), callback);
    }

    @Override
    public void count(Bson filter, CountOptions options, SingleResultCallback<Long> callback) {
        this.executeCount(null, filter, options, CountStrategy.COMMAND, callback);
    }

    @Override
    public void count(ClientSession clientSession, SingleResultCallback<Long> callback) {
        this.count(clientSession, (Bson)new BsonDocument(), callback);
    }

    @Override
    public void count(ClientSession clientSession, Bson filter, SingleResultCallback<Long> callback) {
        this.count(clientSession, filter, new CountOptions(), callback);
    }

    @Override
    public void count(ClientSession clientSession, Bson filter, CountOptions options, SingleResultCallback<Long> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeCount(clientSession, filter, options, CountStrategy.COMMAND, callback);
    }

    @Override
    public void countDocuments(SingleResultCallback<Long> callback) {
        this.countDocuments((Bson)new BsonDocument(), callback);
    }

    @Override
    public void countDocuments(Bson filter, SingleResultCallback<Long> callback) {
        this.countDocuments(filter, new CountOptions(), callback);
    }

    @Override
    public void countDocuments(Bson filter, CountOptions options, SingleResultCallback<Long> callback) {
        this.executeCount(null, filter, options, CountStrategy.AGGREGATE, callback);
    }

    @Override
    public void countDocuments(ClientSession clientSession, SingleResultCallback<Long> callback) {
        this.countDocuments(clientSession, (Bson)new BsonDocument(), callback);
    }

    @Override
    public void countDocuments(ClientSession clientSession, Bson filter, SingleResultCallback<Long> callback) {
        this.countDocuments(clientSession, filter, new CountOptions(), callback);
    }

    @Override
    public void countDocuments(ClientSession clientSession, Bson filter, CountOptions options, SingleResultCallback<Long> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeCount(clientSession, filter, options, CountStrategy.AGGREGATE, callback);
    }

    @Override
    public void estimatedDocumentCount(SingleResultCallback<Long> callback) {
        this.estimatedDocumentCount(new EstimatedDocumentCountOptions(), callback);
    }

    @Override
    public void estimatedDocumentCount(EstimatedDocumentCountOptions options, SingleResultCallback<Long> callback) {
        this.executeCount(null, (Bson)new BsonDocument(), CountOptionsHelper.fromEstimatedDocumentCountOptions((EstimatedDocumentCountOptions)options), CountStrategy.COMMAND, callback);
    }

    private void executeCount(@Nullable ClientSession clientSession, Bson filter, CountOptions options, CountStrategy countStrategy, SingleResultCallback<Long> callback) {
        this.executor.execute(this.operations.count(filter, options, countStrategy), this.readPreference, this.readConcern, clientSession, callback);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Class<TResult> resultClass) {
        return this.distinct(fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(String fieldName, Bson filter, Class<TResult> resultClass) {
        return this.createDistinctIterable(null, fieldName, filter, resultClass);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String fieldName, Class<TResult> resultClass) {
        return this.distinct(clientSession, fieldName, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public <TResult> DistinctIterable<TResult> distinct(ClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createDistinctIterable(clientSession, fieldName, filter, resultClass);
    }

    private <TResult> DistinctIterable<TResult> createDistinctIterable(@Nullable ClientSession clientSession, String fieldName, Bson filter, Class<TResult> resultClass) {
        return new DistinctIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, fieldName, filter);
    }

    @Override
    public FindIterable<TDocument> find() {
        return this.find((Bson)new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Class<TResult> resultClass) {
        return this.find((Bson)new BsonDocument(), resultClass);
    }

    @Override
    public FindIterable<TDocument> find(Bson filter) {
        return this.find(filter, this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(Bson filter, Class<TResult> resultClass) {
        return this.createFindIterable(null, filter, resultClass);
    }

    @Override
    public FindIterable<TDocument> find(ClientSession clientSession) {
        return this.find(clientSession, (Bson)new BsonDocument(), this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Class<TResult> resultClass) {
        return this.find(clientSession, (Bson)new BsonDocument(), resultClass);
    }

    @Override
    public FindIterable<TDocument> find(ClientSession clientSession, Bson filter) {
        return this.find(clientSession, filter, this.documentClass);
    }

    @Override
    public <TResult> FindIterable<TResult> find(ClientSession clientSession, Bson filter, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createFindIterable(clientSession, filter, resultClass);
    }

    private <TResult> FindIterable<TResult> createFindIterable(@Nullable ClientSession clientSession, Bson filter, Class<TResult> resultClass) {
        return new FindIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.executor, filter);
    }

    @Override
    public AggregateIterable<TDocument> aggregate(List<? extends Bson> pipeline) {
        return this.aggregate(pipeline, this.documentClass);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createAggregateIterable(null, pipeline, resultClass);
    }

    @Override
    public AggregateIterable<TDocument> aggregate(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.aggregate(clientSession, pipeline, this.documentClass);
    }

    @Override
    public <TResult> AggregateIterable<TResult> aggregate(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createAggregateIterable(clientSession, pipeline, resultClass);
    }

    private <TResult> AggregateIterable<TResult> createAggregateIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new AggregateIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, pipeline, AggregationLevel.COLLECTION);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch() {
        return this.watch(Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(Class<TResult> resultClass) {
        return this.watch(Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch(List<? extends Bson> pipeline) {
        return this.watch(pipeline, this.documentClass);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return this.createChangeStreamIterable(null, pipeline, resultClass);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession) {
        return this.watch(clientSession, Collections.emptyList());
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, Class<TResult> resultClass) {
        return this.watch(clientSession, Collections.emptyList(), resultClass);
    }

    @Override
    public ChangeStreamIterable<TDocument> watch(ClientSession clientSession, List<? extends Bson> pipeline) {
        return this.watch(clientSession, pipeline, this.documentClass);
    }

    @Override
    public <TResult> ChangeStreamIterable<TResult> watch(ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createChangeStreamIterable(clientSession, pipeline, resultClass);
    }

    private <TResult> ChangeStreamIterable<TResult> createChangeStreamIterable(@Nullable ClientSession clientSession, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        return new ChangeStreamIterableImpl<TResult>(clientSession, this.namespace, this.codecRegistry, this.readPreference, this.readConcern, this.executor, pipeline, resultClass, ChangeStreamLevel.COLLECTION);
    }

    @Override
    public MapReduceIterable<TDocument> mapReduce(String mapFunction, String reduceFunction) {
        return this.mapReduce(mapFunction, reduceFunction, this.documentClass);
    }

    @Override
    public <TResult> MapReduceIterable<TResult> mapReduce(String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return this.createMapReduceIterable(null, mapFunction, reduceFunction, resultClass);
    }

    @Override
    public MapReduceIterable<TDocument> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction) {
        return this.mapReduce(clientSession, mapFunction, reduceFunction, this.documentClass);
    }

    @Override
    public <TResult> MapReduceIterable<TResult> mapReduce(ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createMapReduceIterable(clientSession, mapFunction, reduceFunction, resultClass);
    }

    private <TResult> MapReduceIterable<TResult> createMapReduceIterable(@Nullable ClientSession clientSession, String mapFunction, String reduceFunction, Class<TResult> resultClass) {
        return new MapReduceIterableImpl<TDocument, TResult>(clientSession, this.namespace, this.documentClass, resultClass, this.codecRegistry, this.readPreference, this.readConcern, this.writeConcern, this.executor, mapFunction, reduceFunction);
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, SingleResultCallback<BulkWriteResult> callback) {
        this.bulkWrite(requests, new BulkWriteOptions(), callback);
    }

    @Override
    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options, SingleResultCallback<BulkWriteResult> callback) {
        this.executeBulkWrite(null, requests, options, callback);
    }

    @Override
    public void bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, SingleResultCallback<BulkWriteResult> callback) {
        this.bulkWrite(clientSession, requests, new BulkWriteOptions(), callback);
    }

    @Override
    public void bulkWrite(ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options, SingleResultCallback<BulkWriteResult> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeBulkWrite(clientSession, requests, options, callback);
    }

    private void executeBulkWrite(@Nullable ClientSession clientSession, List<? extends WriteModel<? extends TDocument>> requests, BulkWriteOptions options, SingleResultCallback<BulkWriteResult> callback) {
        Assertions.notNull((String)"requests", requests);
        this.executor.execute(this.operations.bulkWrite(requests, options), this.readConcern, clientSession, callback);
    }

    @Override
    public void insertOne(TDocument document, SingleResultCallback<Void> callback) {
        this.insertOne(document, new InsertOneOptions(), callback);
    }

    @Override
    public void insertOne(TDocument document, InsertOneOptions options, SingleResultCallback<Void> callback) {
        this.executeInsertOne(null, document, options, callback);
    }

    @Override
    public void insertOne(ClientSession clientSession, TDocument document, SingleResultCallback<Void> callback) {
        this.insertOne(clientSession, document, new InsertOneOptions(), callback);
    }

    @Override
    public void insertOne(ClientSession clientSession, TDocument document, InsertOneOptions options, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeInsertOne(clientSession, document, options, callback);
    }

    private void executeInsertOne(@Nullable ClientSession clientSession, TDocument document, InsertOneOptions options, final SingleResultCallback<Void> callback) {
        this.executeSingleWriteRequest(clientSession, (AsyncWriteOperation<BulkWriteResult>)this.operations.insertOne(document, options), WriteRequest.Type.INSERT, new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                callback.onResult(null, t);
            }
        });
    }

    @Override
    public void insertMany(List<? extends TDocument> documents, SingleResultCallback<Void> callback) {
        this.insertMany(documents, new InsertManyOptions(), callback);
    }

    @Override
    public void insertMany(List<? extends TDocument> documents, InsertManyOptions options, SingleResultCallback<Void> callback) {
        this.executeInsertMany(null, documents, options, callback);
    }

    @Override
    public void insertMany(ClientSession clientSession, List<? extends TDocument> documents, SingleResultCallback<Void> callback) {
        this.insertMany(clientSession, documents, new InsertManyOptions(), callback);
    }

    @Override
    public void insertMany(ClientSession clientSession, List<? extends TDocument> documents, InsertManyOptions options, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeInsertMany(clientSession, documents, options, callback);
    }

    private void executeInsertMany(@Nullable ClientSession clientSession, List<? extends TDocument> documents, InsertManyOptions options, final SingleResultCallback<Void> callback) {
        this.executor.execute(this.operations.insertMany(documents, options), this.readConcern, clientSession, new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                callback.onResult(null, t);
            }
        });
    }

    @Override
    public void deleteOne(Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.deleteOne(filter, new DeleteOptions(), callback);
    }

    @Override
    public void deleteOne(Bson filter, DeleteOptions options, SingleResultCallback<DeleteResult> callback) {
        this.executeDelete(null, filter, options, false, callback);
    }

    @Override
    public void deleteOne(ClientSession clientSession, Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.deleteOne(clientSession, filter, new DeleteOptions(), callback);
    }

    @Override
    public void deleteOne(ClientSession clientSession, Bson filter, DeleteOptions options, SingleResultCallback<DeleteResult> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDelete(clientSession, filter, options, false, callback);
    }

    @Override
    public void deleteMany(Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.deleteMany(filter, new DeleteOptions(), callback);
    }

    @Override
    public void deleteMany(Bson filter, DeleteOptions options, SingleResultCallback<DeleteResult> callback) {
        this.executeDelete(null, filter, options, true, callback);
    }

    @Override
    public void deleteMany(ClientSession clientSession, Bson filter, SingleResultCallback<DeleteResult> callback) {
        this.deleteMany(clientSession, filter, new DeleteOptions(), callback);
    }

    @Override
    public void deleteMany(ClientSession clientSession, Bson filter, DeleteOptions options, SingleResultCallback<DeleteResult> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDelete(clientSession, filter, options, true, callback);
    }

    private void executeDelete(@Nullable ClientSession clientSession, Bson filter, DeleteOptions options, boolean multi, final SingleResultCallback<DeleteResult> callback) {
        this.executeSingleWriteRequest(clientSession, (AsyncWriteOperation<BulkWriteResult>)(multi ? this.operations.deleteMany(filter, options) : this.operations.deleteOne(filter, options)), WriteRequest.Type.DELETE, new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else if (result.wasAcknowledged()) {
                    callback.onResult((Object)DeleteResult.acknowledged((long)result.getDeletedCount()), null);
                } else {
                    callback.onResult((Object)DeleteResult.unacknowledged(), null);
                }
            }
        });
    }

    @Override
    public void replaceOne(Bson filter, TDocument replacement, SingleResultCallback<UpdateResult> callback) {
        this.replaceOne(filter, replacement, new ReplaceOptions(), callback);
    }

    @Override
    public void replaceOne(Bson filter, TDocument replacement, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.replaceOne(filter, replacement, ReplaceOptions.createReplaceOptions((UpdateOptions)options), callback);
    }

    @Override
    public void replaceOne(Bson filter, TDocument replacement, ReplaceOptions options, SingleResultCallback<UpdateResult> callback) {
        this.executeReplaceOne(null, filter, replacement, options, callback);
    }

    @Override
    public void replaceOne(ClientSession clientSession, Bson filter, TDocument replacement, SingleResultCallback<UpdateResult> callback) {
        this.replaceOne(clientSession, filter, replacement, new ReplaceOptions(), callback);
    }

    @Override
    public void replaceOne(ClientSession clientSession, Bson filter, TDocument replacement, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.replaceOne(clientSession, filter, replacement, ReplaceOptions.createReplaceOptions((UpdateOptions)options), callback);
    }

    @Override
    public void replaceOne(ClientSession clientSession, Bson filter, TDocument replacement, ReplaceOptions options, SingleResultCallback<UpdateResult> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeReplaceOne(clientSession, filter, replacement, options, callback);
    }

    private void executeReplaceOne(@Nullable ClientSession clientSession, Bson filter, TDocument replacement, ReplaceOptions options, final SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest(clientSession, (AsyncWriteOperation<BulkWriteResult>)this.operations.replaceOne(filter, replacement, options), WriteRequest.Type.REPLACE, new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)MongoCollectionImpl.this.toUpdateResult(result), null);
                }
            }
        });
    }

    @Override
    public void updateOne(Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateOne(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateOne(Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.executeUpdate(null, filter, update, options, false, callback);
    }

    @Override
    public void updateOne(ClientSession clientSession, Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateOne(clientSession, filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateOne(ClientSession clientSession, Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeUpdate(clientSession, filter, update, options, false, callback);
    }

    @Override
    public void updateMany(Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateMany(filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateMany(Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        this.executeUpdate(null, filter, update, options, true, callback);
    }

    @Override
    public void updateMany(ClientSession clientSession, Bson filter, Bson update, SingleResultCallback<UpdateResult> callback) {
        this.updateMany(clientSession, filter, update, new UpdateOptions(), callback);
    }

    @Override
    public void updateMany(ClientSession clientSession, Bson filter, Bson update, UpdateOptions options, SingleResultCallback<UpdateResult> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeUpdate(clientSession, filter, update, options, true, callback);
    }

    private void executeUpdate(@Nullable ClientSession clientSession, Bson filter, Bson update, UpdateOptions options, boolean multi, final SingleResultCallback<UpdateResult> callback) {
        this.executeSingleWriteRequest(clientSession, (AsyncWriteOperation<BulkWriteResult>)(multi ? this.operations.updateMany(filter, update, options) : this.operations.updateOne(filter, update, options)), WriteRequest.Type.UPDATE, new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)MongoCollectionImpl.this.toUpdateResult(result), null);
                }
            }
        });
    }

    @Override
    public void findOneAndDelete(Bson filter, SingleResultCallback<TDocument> callback) {
        this.findOneAndDelete(filter, new FindOneAndDeleteOptions(), callback);
    }

    @Override
    public void findOneAndDelete(Bson filter, FindOneAndDeleteOptions options, SingleResultCallback<TDocument> callback) {
        this.executeFindOneAndDelete(null, filter, options, callback);
    }

    @Override
    public void findOneAndDelete(ClientSession clientSession, Bson filter, SingleResultCallback<TDocument> callback) {
        this.findOneAndDelete(clientSession, filter, new FindOneAndDeleteOptions(), callback);
    }

    @Override
    public void findOneAndDelete(ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options, SingleResultCallback<TDocument> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeFindOneAndDelete(clientSession, filter, options, callback);
    }

    private void executeFindOneAndDelete(@Nullable ClientSession clientSession, Bson filter, FindOneAndDeleteOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute(this.operations.findOneAndDelete(filter, options), this.readConcern, clientSession, callback);
    }

    @Override
    public void findOneAndReplace(Bson filter, TDocument replacement, SingleResultCallback<TDocument> callback) {
        this.findOneAndReplace(filter, replacement, new FindOneAndReplaceOptions(), callback);
    }

    @Override
    public void findOneAndReplace(Bson filter, TDocument replacement, FindOneAndReplaceOptions options, SingleResultCallback<TDocument> callback) {
        this.executeFindOneAndReplace(null, filter, replacement, options, callback);
    }

    @Override
    public void findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement, SingleResultCallback<TDocument> callback) {
        this.findOneAndReplace(clientSession, filter, replacement, new FindOneAndReplaceOptions(), callback);
    }

    @Override
    public void findOneAndReplace(ClientSession clientSession, Bson filter, TDocument replacement, FindOneAndReplaceOptions options, SingleResultCallback<TDocument> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeFindOneAndReplace(clientSession, filter, replacement, options, callback);
    }

    private void executeFindOneAndReplace(@Nullable ClientSession clientSession, Bson filter, TDocument replacement, FindOneAndReplaceOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute(this.operations.findOneAndReplace(filter, replacement, options), this.readConcern, clientSession, callback);
    }

    @Override
    public void findOneAndUpdate(Bson filter, Bson update, SingleResultCallback<TDocument> callback) {
        this.findOneAndUpdate(filter, update, new FindOneAndUpdateOptions(), callback);
    }

    @Override
    public void findOneAndUpdate(Bson filter, Bson update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        this.executeFindOneAndUpdate(null, filter, update, options, callback);
    }

    @Override
    public void findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update, SingleResultCallback<TDocument> callback) {
        this.findOneAndUpdate(clientSession, filter, update, new FindOneAndUpdateOptions(), callback);
    }

    @Override
    public void findOneAndUpdate(ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeFindOneAndUpdate(clientSession, filter, update, options, callback);
    }

    private void executeFindOneAndUpdate(@Nullable ClientSession clientSession, Bson filter, Bson update, FindOneAndUpdateOptions options, SingleResultCallback<TDocument> callback) {
        this.executor.execute(this.operations.findOneAndUpdate(filter, update, options), this.readConcern, clientSession, callback);
    }

    @Override
    public void drop(SingleResultCallback<Void> callback) {
        this.executeDrop(null, callback);
    }

    @Override
    public void drop(ClientSession clientSession, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDrop(clientSession, callback);
    }

    private void executeDrop(@Nullable ClientSession clientSession, SingleResultCallback<Void> callback) {
        this.executor.execute(this.operations.dropCollection(), this.readConcern, clientSession, callback);
    }

    @Override
    public void createIndex(Bson key, SingleResultCallback<String> callback) {
        this.createIndex(key, new IndexOptions(), callback);
    }

    @Override
    public void createIndex(Bson key, IndexOptions indexOptions, final SingleResultCallback<String> callback) {
        this.createIndexes(Collections.singletonList(new IndexModel(key, indexOptions)), new SingleResultCallback<List<String>>(){

            public void onResult(List<String> result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)result.get(0), null);
                }
            }
        });
    }

    @Override
    public void createIndex(ClientSession clientSession, Bson key, SingleResultCallback<String> callback) {
        this.createIndex(clientSession, key, new IndexOptions(), callback);
    }

    @Override
    public void createIndex(ClientSession clientSession, Bson key, IndexOptions indexOptions, final SingleResultCallback<String> callback) {
        this.createIndexes(clientSession, Collections.singletonList(new IndexModel(key, indexOptions)), new SingleResultCallback<List<String>>(){

            public void onResult(List<String> result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)result.get(0), null);
                }
            }
        });
    }

    @Override
    public void createIndexes(List<IndexModel> indexes, SingleResultCallback<List<String>> callback) {
        this.createIndexes(indexes, new CreateIndexOptions(), callback);
    }

    @Override
    public void createIndexes(List<IndexModel> indexes, CreateIndexOptions createIndexOptions, SingleResultCallback<List<String>> callback) {
        this.executeCreateIndexes(null, indexes, createIndexOptions, callback);
    }

    @Override
    public void createIndexes(ClientSession clientSession, List<IndexModel> indexes, SingleResultCallback<List<String>> callback) {
        this.createIndexes(clientSession, indexes, new CreateIndexOptions(), callback);
    }

    @Override
    public void createIndexes(ClientSession clientSession, List<IndexModel> indexes, CreateIndexOptions createIndexOptions, SingleResultCallback<List<String>> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeCreateIndexes(clientSession, indexes, createIndexOptions, callback);
    }

    private void executeCreateIndexes(@Nullable ClientSession clientSession, final List<IndexModel> indexes, CreateIndexOptions createIndexOptions, final SingleResultCallback<List<String>> callback) {
        this.executor.execute(this.operations.createIndexes(indexes, createIndexOptions), this.readConcern, clientSession, new SingleResultCallback<Void>(){

            public void onResult(Void result, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult((Object)IndexHelper.getIndexNames((List)indexes, (CodecRegistry)MongoCollectionImpl.this.codecRegistry), null);
                }
            }
        });
    }

    @Override
    public ListIndexesIterable<Document> listIndexes() {
        return this.listIndexes(Document.class);
    }

    @Override
    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> resultClass) {
        return this.createListIndexesIterable(null, resultClass);
    }

    @Override
    public ListIndexesIterable<Document> listIndexes(ClientSession clientSession) {
        return this.listIndexes(clientSession, Document.class);
    }

    @Override
    public <TResult> ListIndexesIterable<TResult> listIndexes(ClientSession clientSession, Class<TResult> resultClass) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        return this.createListIndexesIterable(clientSession, resultClass);
    }

    private <TResult> ListIndexesIterable<TResult> createListIndexesIterable(@Nullable ClientSession clientSession, Class<TResult> resultClass) {
        return new ListIndexesIterableImpl<TResult>(clientSession, this.namespace, resultClass, this.codecRegistry, this.readPreference, this.executor);
    }

    @Override
    public void dropIndex(String indexName, SingleResultCallback<Void> callback) {
        this.dropIndex(indexName, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndex(String indexName, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.executeDropIndex(null, indexName, dropIndexOptions, callback);
    }

    @Override
    public void dropIndex(Bson keys, SingleResultCallback<Void> callback) {
        this.dropIndex(keys, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndex(Bson keys, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.executeDropIndex(null, keys, dropIndexOptions, callback);
    }

    @Override
    public void dropIndex(ClientSession clientSession, String indexName, SingleResultCallback<Void> callback) {
        this.dropIndex(clientSession, indexName, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndex(ClientSession clientSession, String indexName, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDropIndex(clientSession, indexName, dropIndexOptions, callback);
    }

    @Override
    public void dropIndex(ClientSession clientSession, Bson keys, SingleResultCallback<Void> callback) {
        this.dropIndex(clientSession, keys, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndex(ClientSession clientSession, Bson keys, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeDropIndex(clientSession, keys, dropIndexOptions, callback);
    }

    @Override
    public void dropIndexes(SingleResultCallback<Void> callback) {
        this.dropIndexes(new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndexes(DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.dropIndex("*", dropIndexOptions, callback);
    }

    @Override
    public void dropIndexes(ClientSession clientSession, SingleResultCallback<Void> callback) {
        this.dropIndexes(clientSession, new DropIndexOptions(), callback);
    }

    @Override
    public void dropIndexes(ClientSession clientSession, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.dropIndex(clientSession, "*", dropIndexOptions, callback);
    }

    private void executeDropIndex(@Nullable ClientSession clientSession, Bson keys, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.executor.execute(this.operations.dropIndex(keys, dropIndexOptions), this.readConcern, clientSession, callback);
    }

    private void executeDropIndex(@Nullable ClientSession clientSession, String indexName, DropIndexOptions dropIndexOptions, SingleResultCallback<Void> callback) {
        this.executor.execute(this.operations.dropIndex(indexName, dropIndexOptions), this.readConcern, clientSession, callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, SingleResultCallback<Void> callback) {
        this.renameCollection(newCollectionNamespace, new RenameCollectionOptions(), callback);
    }

    @Override
    public void renameCollection(MongoNamespace newCollectionNamespace, RenameCollectionOptions options, SingleResultCallback<Void> callback) {
        this.executeRenameCollection(null, newCollectionNamespace, options, callback);
    }

    @Override
    public void renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace, SingleResultCallback<Void> callback) {
        this.renameCollection(clientSession, newCollectionNamespace, new RenameCollectionOptions(), callback);
    }

    @Override
    public void renameCollection(ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options, SingleResultCallback<Void> callback) {
        Assertions.notNull((String)"clientSession", (Object)clientSession);
        this.executeRenameCollection(clientSession, newCollectionNamespace, options, callback);
    }

    private void executeRenameCollection(@Nullable ClientSession clientSession, MongoNamespace newCollectionNamespace, RenameCollectionOptions options, SingleResultCallback<Void> callback) {
        this.executor.execute(this.operations.renameCollection(newCollectionNamespace, options), this.readConcern, clientSession, callback);
    }

    private void executeSingleWriteRequest(@Nullable ClientSession clientSession, AsyncWriteOperation<BulkWriteResult> writeOperation, final WriteRequest.Type type, final SingleResultCallback<BulkWriteResult> callback) {
        this.executor.execute(writeOperation, this.readConcern, clientSession, new SingleResultCallback<BulkWriteResult>(){

            public void onResult(BulkWriteResult result, Throwable t) {
                if (t instanceof MongoBulkWriteException) {
                    MongoBulkWriteException e = (MongoBulkWriteException)t;
                    if (e.getWriteErrors().isEmpty()) {
                        callback.onResult(null, (Throwable)new MongoWriteConcernException(e.getWriteConcernError(), MongoCollectionImpl.this.translateBulkWriteResult(type, e.getWriteResult()), e.getServerAddress()));
                    } else {
                        callback.onResult(null, (Throwable)new MongoWriteException(new WriteError((WriteError)e.getWriteErrors().get(0)), e.getServerAddress()));
                    }
                } else {
                    callback.onResult((Object)result, t);
                }
            }
        });
    }

    private WriteConcernResult translateBulkWriteResult(WriteRequest.Type type, BulkWriteResult writeResult) {
        switch (type) {
            case INSERT: {
                return WriteConcernResult.acknowledged((int)writeResult.getInsertedCount(), (boolean)false, null);
            }
            case DELETE: {
                return WriteConcernResult.acknowledged((int)writeResult.getDeletedCount(), (boolean)false, null);
            }
            case UPDATE: 
            case REPLACE: {
                return WriteConcernResult.acknowledged((int)(writeResult.getMatchedCount() + writeResult.getUpserts().size()), (writeResult.getMatchedCount() > 0 ? 1 : 0) != 0, writeResult.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)writeResult.getUpserts().get(0)).getId());
            }
        }
        throw new MongoInternalException("Unhandled write request type: " + type);
    }

    private UpdateResult toUpdateResult(BulkWriteResult result) {
        if (result.wasAcknowledged()) {
            Long modifiedCount = result.isModifiedCountAvailable() ? Long.valueOf(result.getModifiedCount()) : null;
            BsonValue upsertedId = result.getUpserts().isEmpty() ? null : ((BulkWriteUpsert)result.getUpserts().get(0)).getId();
            return UpdateResult.acknowledged((long)result.getMatchedCount(), (Long)modifiedCount, (BsonValue)upsertedId);
        }
        return UpdateResult.unacknowledged();
    }
}

