/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoClientException;
import com.mongodb.MongoException;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoSocketException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ClientSession;
import com.mongodb.async.client.ClientSessionBinding;
import com.mongodb.async.client.ClientSessionHelper;
import com.mongodb.async.client.MongoClientImpl;
import com.mongodb.async.client.OperationExecutor;
import com.mongodb.binding.AsyncClusterBinding;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.binding.AsyncSingleServerBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.connection.Cluster;
import com.mongodb.connection.ClusterConnectionMode;
import com.mongodb.connection.ClusterDescription;
import com.mongodb.connection.ClusterType;
import com.mongodb.connection.Server;
import com.mongodb.connection.ServerDescription;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.lang.Nullable;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import com.mongodb.selector.ReadPreferenceServerSelector;
import com.mongodb.selector.ServerSelector;
import java.util.List;

class OperationExecutorImpl
implements OperationExecutor {
    private static final Logger LOGGER = Loggers.getLogger((String)"client");
    private final MongoClientImpl mongoClient;
    private final ClientSessionHelper clientSessionHelper;

    OperationExecutorImpl(MongoClientImpl mongoClient, ClientSessionHelper clientSessionHelper) {
        this.mongoClient = mongoClient;
        this.clientSessionHelper = clientSessionHelper;
    }

    @Override
    public <T> void execute(AsyncReadOperation<T> operation, ReadPreference readPreference, ReadConcern readConcern, SingleResultCallback<T> callback) {
        this.execute(operation, readPreference, readConcern, null, callback);
    }

    @Override
    public <T> void execute(final AsyncReadOperation<T> operation, final ReadPreference readPreference, final ReadConcern readConcern, final @Nullable ClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        this.clientSessionHelper.withClientSession(session, this, new SingleResultCallback<ClientSession>(){

            public void onResult(ClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    OperationExecutorImpl.this.getReadWriteBinding(readPreference, readConcern, clientSession, session == null && clientSession != null, (SingleResultCallback<AsyncReadWriteBinding>)((SingleResultCallback)new SingleResultCallback<AsyncReadWriteBinding>(){

                        public void onResult(final AsyncReadWriteBinding binding, Throwable t) {
                            if (t != null) {
                                errHandlingCallback.onResult(null, t);
                            } else if (session != null && session.hasActiveTransaction() && !binding.getReadPreference().equals(ReadPreference.primary())) {
                                binding.release();
                                errHandlingCallback.onResult(null, (Throwable)new MongoClientException("Read preference in a transaction must be primary"));
                            } else {
                                operation.executeAsync((AsyncReadBinding)binding, new SingleResultCallback<T>(){

                                    public void onResult(T result, Throwable t) {
                                        try {
                                            OperationExecutorImpl.this.labelException(t, session);
                                            errHandlingCallback.onResult(result, t);
                                        }
                                        finally {
                                            binding.release();
                                        }
                                    }
                                });
                            }
                        }
                    }));
                }
            }
        });
    }

    @Override
    public <T> void execute(AsyncWriteOperation<T> operation, ReadConcern readConcern, SingleResultCallback<T> callback) {
        this.execute(operation, readConcern, null, callback);
    }

    @Override
    public <T> void execute(final AsyncWriteOperation<T> operation, final ReadConcern readConcern, final @Nullable ClientSession session, SingleResultCallback<T> callback) {
        Assertions.notNull((String)"operation", operation);
        Assertions.notNull((String)"callback", callback);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        this.clientSessionHelper.withClientSession(session, this, new SingleResultCallback<ClientSession>(){

            public void onResult(ClientSession clientSession, Throwable t) {
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    OperationExecutorImpl.this.getReadWriteBinding(ReadPreference.primary(), readConcern, clientSession, session == null && clientSession != null, (SingleResultCallback<AsyncReadWriteBinding>)((SingleResultCallback)new SingleResultCallback<AsyncReadWriteBinding>(){

                        public void onResult(final AsyncReadWriteBinding binding, Throwable t) {
                            if (t != null) {
                                errHandlingCallback.onResult(null, t);
                            } else {
                                operation.executeAsync((AsyncWriteBinding)binding, new SingleResultCallback<T>(){

                                    public void onResult(T result, Throwable t) {
                                        try {
                                            OperationExecutorImpl.this.labelException(t, session);
                                            errHandlingCallback.onResult(result, t);
                                        }
                                        finally {
                                            binding.release();
                                        }
                                    }
                                });
                            }
                        }
                    }));
                }
            }
        });
    }

    private void labelException(Throwable t, ClientSession session) {
        if ((t instanceof MongoSocketException || t instanceof MongoTimeoutException) && session != null && session.hasActiveTransaction() && !((MongoException)t).hasErrorLabel("UnknownTransactionCommitResult")) {
            ((MongoException)t).addLabel("TransientTransactionError");
        }
    }

    private void getReadWriteBinding(final ReadPreference readPreference, final ReadConcern readConcern, final @Nullable ClientSession session, final boolean ownsSession, final SingleResultCallback<AsyncReadWriteBinding> callback) {
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        final SingleResultCallback errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, (Logger)LOGGER);
        final Cluster cluster = this.mongoClient.getCluster();
        if (session != null && session.hasActiveTransaction()) {
            this.getClusterType(cluster, new SingleResultCallback<ClusterType>(){

                public void onResult(ClusterType clusterType, Throwable t) {
                    if (t != null) {
                        errHandlingCallback.onResult(null, t);
                    } else if (clusterType == ClusterType.SHARDED) {
                        OperationExecutorImpl.this.bindWithPinnedMongos(cluster, readPreference, session, ownsSession, (SingleResultCallback<AsyncReadWriteBinding>)errHandlingCallback, (SingleResultCallback<AsyncReadWriteBinding>)callback);
                    } else {
                        OperationExecutorImpl.this.allocateReadWriteBinding(readPreference, readConcern, session, ownsSession, (SingleResultCallback<AsyncReadWriteBinding>)callback);
                    }
                }
            });
        } else {
            this.allocateReadWriteBinding(readPreference, readConcern, session, ownsSession, callback);
        }
    }

    private void bindWithPinnedMongos(final Cluster cluster, final ReadPreference readPreference, final ClientSession session, final boolean ownsSession, final SingleResultCallback<AsyncReadWriteBinding> errHandlingCallback, final SingleResultCallback<AsyncReadWriteBinding> callback) {
        if (session.getPinnedMongosAddress() == null) {
            cluster.selectServerAsync((ServerSelector)new ReadPreferenceServerSelector(this.getReadPreferenceForBinding(readPreference, session)), (SingleResultCallback)new SingleResultCallback<Server>(){

                public void onResult(Server server, Throwable t) {
                    if (t != null) {
                        errHandlingCallback.onResult(null, t);
                    } else {
                        session.setPinnedMongosAddress(server.getDescription().getAddress());
                        AsyncSingleServerBinding binding = new AsyncSingleServerBinding(cluster, server.getDescription().getAddress(), OperationExecutorImpl.this.getReadPreferenceForBinding(readPreference, session));
                        callback.onResult((Object)new ClientSessionBinding(session, ownsSession, (AsyncReadWriteBinding)binding), null);
                    }
                }
            });
        } else {
            AsyncSingleServerBinding binding = new AsyncSingleServerBinding(cluster, session.getPinnedMongosAddress(), this.getReadPreferenceForBinding(readPreference, session));
            callback.onResult((Object)new ClientSessionBinding(session, ownsSession, (AsyncReadWriteBinding)binding), null);
        }
    }

    private void allocateReadWriteBinding(ReadPreference readPreference, ReadConcern readConcern, ClientSession session, boolean ownsSession, SingleResultCallback<AsyncReadWriteBinding> callback) {
        AsyncClusterBinding readWriteBinding = new AsyncClusterBinding(this.mongoClient.getCluster(), this.getReadPreferenceForBinding(readPreference, session), readConcern);
        if (session != null) {
            callback.onResult((Object)new ClientSessionBinding(session, ownsSession, (AsyncReadWriteBinding)readWriteBinding), null);
        } else {
            callback.onResult((Object)readWriteBinding, null);
        }
    }

    private void getClusterType(Cluster cluster, final SingleResultCallback<ClusterType> callback) {
        ClusterDescription description = cluster.getCurrentDescription();
        if (description.getType() != ClusterType.UNKNOWN) {
            callback.onResult((Object)description.getType(), null);
        } else {
            this.mongoClient.getCluster().selectServerAsync(new ServerSelector(){

                public List<ServerDescription> select(ClusterDescription clusterDescription) {
                    if (clusterDescription.getConnectionMode() == ClusterConnectionMode.SINGLE) {
                        return clusterDescription.getAny();
                    }
                    return clusterDescription.getAnyPrimaryOrSecondary();
                }
            }, (SingleResultCallback)new SingleResultCallback<Server>(){

                public void onResult(Server server, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        callback.onResult((Object)server.getDescription().getType().getClusterType(), null);
                    }
                }
            });
        }
    }

    private ReadPreference getReadPreferenceForBinding(ReadPreference readPreference, @Nullable ClientSession session) {
        if (session == null) {
            return readPreference;
        }
        if (session.hasActiveTransaction()) {
            ReadPreference readPreferenceForBinding = session.getTransactionOptions().getReadPreference();
            if (readPreferenceForBinding == null) {
                throw new MongoInternalException("Invariant violated.  Transaction options read preference can not be null");
            }
            return readPreferenceForBinding;
        }
        return readPreference;
    }
}

