/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Function;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ListDatabasesIterable;
import com.mongodb.async.client.ListDatabasesIterableImpl;
import com.mongodb.async.client.MongoClient;
import com.mongodb.async.client.MongoClientSettings;
import com.mongodb.async.client.MongoDatabase;
import com.mongodb.async.client.MongoDatabaseImpl;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.binding.AsyncClusterBinding;
import com.mongodb.binding.AsyncReadBinding;
import com.mongodb.binding.AsyncReadWriteBinding;
import com.mongodb.binding.AsyncWriteBinding;
import com.mongodb.connection.Cluster;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import com.mongodb.operation.AsyncWriteOperation;
import java.util.Arrays;
import org.bson.BsonDocument;
import org.bson.Document;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DocumentCodecProvider;
import org.bson.codecs.ValueCodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;

class MongoClientImpl
implements MongoClient {
    private final Cluster cluster;
    private final MongoClientSettings settings;
    private final AsyncOperationExecutor executor;
    private static final CodecRegistry DEFAULT_CODEC_REGISTRY = CodecRegistries.fromProviders(Arrays.asList(new ValueCodecProvider(), new DocumentCodecProvider(), new BsonValueCodecProvider()));

    public static CodecRegistry getDefaultCodecRegistry() {
        return DEFAULT_CODEC_REGISTRY;
    }

    MongoClientImpl(MongoClientSettings settings, Cluster cluster) {
        this(settings, cluster, MongoClientImpl.createOperationExecutor(settings, cluster));
    }

    MongoClientImpl(MongoClientSettings settings, Cluster cluster, AsyncOperationExecutor executor) {
        this.settings = (MongoClientSettings)Assertions.notNull((String)"settings", (Object)settings);
        this.cluster = (Cluster)Assertions.notNull((String)"cluster", (Object)cluster);
        this.executor = (AsyncOperationExecutor)Assertions.notNull((String)"executor", (Object)executor);
    }

    @Override
    public MongoDatabase getDatabase(String name) {
        return new MongoDatabaseImpl(name, this.settings.getCodecRegistry(), this.settings.getReadPreference(), this.settings.getWriteConcern(), this.executor);
    }

    @Override
    public void close() {
        this.cluster.close();
    }

    @Override
    public MongoClientSettings getSettings() {
        return this.settings;
    }

    @Override
    public MongoIterable<String> listDatabaseNames() {
        return new ListDatabasesIterableImpl<BsonDocument>(BsonDocument.class, MongoClientImpl.getDefaultCodecRegistry(), ReadPreference.primary(), this.executor).map(new Function<BsonDocument, String>(){

            public String apply(BsonDocument document) {
                return document.getString((Object)"name").getValue();
            }
        });
    }

    @Override
    public ListDatabasesIterable<Document> listDatabases() {
        return this.listDatabases((Class<T>)Document.class);
    }

    public <T> ListDatabasesIterable<T> listDatabases(Class<T> resultClass) {
        return new ListDatabasesIterableImpl<T>(resultClass, this.settings.getCodecRegistry(), ReadPreference.primary(), this.executor);
    }

    Cluster getCluster() {
        return this.cluster;
    }

    private static AsyncOperationExecutor createOperationExecutor(MongoClientSettings settings, final Cluster cluster) {
        return new AsyncOperationExecutor(){

            public <T> void execute(AsyncReadOperation<T> operation, ReadPreference readPreference, SingleResultCallback<T> callback) {
                final SingleResultCallback wrappedCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback);
                AsyncReadWriteBinding binding = MongoClientImpl.getReadWriteBinding(readPreference, cluster);
                operation.executeAsync((AsyncReadBinding)binding, new SingleResultCallback<T>((AsyncReadBinding)binding){
                    final /* synthetic */ AsyncReadBinding val$binding;
                    {
                        this.val$binding = asyncReadBinding;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResult(T result, Throwable t) {
                        try {
                            wrappedCallback.onResult(result, t);
                        }
                        finally {
                            this.val$binding.release();
                        }
                    }
                });
            }

            public <T> void execute(AsyncWriteOperation<T> operation, final SingleResultCallback<T> callback) {
                AsyncReadWriteBinding binding = MongoClientImpl.getReadWriteBinding(ReadPreference.primary(), cluster);
                operation.executeAsync((AsyncWriteBinding)binding, new SingleResultCallback<T>((AsyncWriteBinding)binding){
                    final /* synthetic */ AsyncWriteBinding val$binding;
                    {
                        this.val$binding = asyncWriteBinding;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResult(T result, Throwable t) {
                        try {
                            ErrorHandlingResultCallback.errorHandlingCallback((SingleResultCallback)callback).onResult(result, t);
                        }
                        finally {
                            this.val$binding.release();
                        }
                    }
                });
            }
        };
    }

    private static AsyncReadWriteBinding getReadWriteBinding(ReadPreference readPreference, Cluster cluster) {
        Assertions.notNull((String)"readPreference", (Object)readPreference);
        return new AsyncClusterBinding(cluster, readPreference);
    }
}

