/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.ListCollectionsIterable;
import com.mongodb.async.client.MongoCollection;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.client.model.CreateCollectionOptions;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@ThreadSafe
public interface MongoDatabase {
    public String getName();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public MongoDatabase withCodecRegistry(CodecRegistry var1);

    public MongoDatabase withReadPreference(ReadPreference var1);

    public MongoDatabase withWriteConcern(WriteConcern var1);

    public MongoCollection<Document> getCollection(String var1);

    public <TDocument> MongoCollection<TDocument> getCollection(String var1, Class<TDocument> var2);

    public void executeCommand(Bson var1, SingleResultCallback<Document> var2);

    public void executeCommand(Bson var1, ReadPreference var2, SingleResultCallback<Document> var3);

    public <TResult> void executeCommand(Bson var1, Class<TResult> var2, SingleResultCallback<TResult> var3);

    public <TResult> void executeCommand(Bson var1, ReadPreference var2, Class<TResult> var3, SingleResultCallback<TResult> var4);

    public void dropDatabase(SingleResultCallback<Void> var1);

    public MongoIterable<String> listCollectionNames();

    public ListCollectionsIterable<Document> listCollections();

    public <TResult> ListCollectionsIterable<TResult> listCollections(Class<TResult> var1);

    public void createCollection(String var1, SingleResultCallback<Void> var2);

    public void createCollection(String var1, CreateCollectionOptions var2, SingleResultCallback<Void> var3);
}

