/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.AggregateIterable;
import com.mongodb.async.client.DistinctIterable;
import com.mongodb.async.client.FindIterable;
import com.mongodb.async.client.ListIndexesIterable;
import com.mongodb.async.client.MapReduceIterable;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

@ThreadSafe
public interface MongoCollection<TDocument> {
    public MongoNamespace getNamespace();

    public Class<TDocument> getDocumentClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public <NewTDocument> MongoCollection<NewTDocument> withDocumentClass(Class<NewTDocument> var1);

    public MongoCollection<TDocument> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<TDocument> withReadPreference(ReadPreference var1);

    public MongoCollection<TDocument> withWriteConcern(WriteConcern var1);

    public void count(SingleResultCallback<Long> var1);

    public void count(Bson var1, SingleResultCallback<Long> var2);

    public void count(Bson var1, CountOptions var2, SingleResultCallback<Long> var3);

    public <TResult> DistinctIterable<TResult> distinct(String var1, Class<TResult> var2);

    public FindIterable<TDocument> find();

    public <TResult> FindIterable<TResult> find(Class<TResult> var1);

    public FindIterable<TDocument> find(Bson var1);

    public <TResult> FindIterable<TResult> find(Bson var1, Class<TResult> var2);

    public AggregateIterable<TDocument> aggregate(List<? extends Bson> var1);

    public <TResult> AggregateIterable<TResult> aggregate(List<? extends Bson> var1, Class<TResult> var2);

    public MapReduceIterable<TDocument> mapReduce(String var1, String var2);

    public <TResult> MapReduceIterable<TResult> mapReduce(String var1, String var2, Class<TResult> var3);

    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, SingleResultCallback<BulkWriteResult> var2);

    public void bulkWrite(List<? extends WriteModel<? extends TDocument>> var1, BulkWriteOptions var2, SingleResultCallback<BulkWriteResult> var3);

    public void insertOne(TDocument var1, SingleResultCallback<Void> var2);

    public void insertMany(List<? extends TDocument> var1, SingleResultCallback<Void> var2);

    public void insertMany(List<? extends TDocument> var1, InsertManyOptions var2, SingleResultCallback<Void> var3);

    public void deleteOne(Bson var1, SingleResultCallback<DeleteResult> var2);

    public void deleteMany(Bson var1, SingleResultCallback<DeleteResult> var2);

    public void replaceOne(Bson var1, TDocument var2, SingleResultCallback<UpdateResult> var3);

    public void replaceOne(Bson var1, TDocument var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateOne(Bson var1, Bson var2, SingleResultCallback<UpdateResult> var3);

    public void updateOne(Bson var1, Bson var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void updateMany(Bson var1, Bson var2, SingleResultCallback<UpdateResult> var3);

    public void updateMany(Bson var1, Bson var2, UpdateOptions var3, SingleResultCallback<UpdateResult> var4);

    public void findOneAndDelete(Bson var1, SingleResultCallback<TDocument> var2);

    public void findOneAndDelete(Bson var1, FindOneAndDeleteOptions var2, SingleResultCallback<TDocument> var3);

    public void findOneAndReplace(Bson var1, TDocument var2, SingleResultCallback<TDocument> var3);

    public void findOneAndReplace(Bson var1, TDocument var2, FindOneAndReplaceOptions var3, SingleResultCallback<TDocument> var4);

    public void findOneAndUpdate(Bson var1, Bson var2, SingleResultCallback<TDocument> var3);

    public void findOneAndUpdate(Bson var1, Bson var2, FindOneAndUpdateOptions var3, SingleResultCallback<TDocument> var4);

    public void dropCollection(SingleResultCallback<Void> var1);

    public void createIndex(Bson var1, SingleResultCallback<Void> var2);

    public void createIndex(Bson var1, CreateIndexOptions var2, SingleResultCallback<Void> var3);

    public ListIndexesIterable<Document> listIndexes();

    public <TResult> ListIndexesIterable<TResult> listIndexes(Class<TResult> var1);

    public void dropIndex(String var1, SingleResultCallback<Void> var2);

    public void dropIndexes(SingleResultCallback<Void> var1);

    public void renameCollection(MongoNamespace var1, SingleResultCallback<Void> var2);

    public void renameCollection(MongoNamespace var1, RenameCollectionOptions var2, SingleResultCallback<Void> var3);
}

