/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.async.client;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.ReadPreference;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.async.client.MappingIterable;
import com.mongodb.async.client.MongoIterable;
import com.mongodb.diagnostics.logging.Logger;
import com.mongodb.diagnostics.logging.Loggers;
import com.mongodb.operation.AsyncOperationExecutor;
import com.mongodb.operation.AsyncReadOperation;
import java.util.Collection;
import java.util.List;

class OperationIterable<T>
implements MongoIterable<T> {
    private static final Logger LOGGER = Loggers.getLogger((String)"async.client");
    private final AsyncReadOperation<? extends AsyncBatchCursor<T>> operation;
    private final ReadPreference readPreference;
    private final AsyncOperationExecutor executor;

    OperationIterable(AsyncReadOperation<? extends AsyncBatchCursor<T>> operation, ReadPreference readPreference, AsyncOperationExecutor executor) {
        this.operation = operation;
        this.readPreference = readPreference;
        this.executor = executor;
    }

    @Override
    public void forEach(final Block<? super T> block, final SingleResultCallback<Void> callback) {
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<T>>(){

            public void onResult(AsyncBatchCursor<T> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    OperationIterable.this.loopCursor(batchCursor, block, (SingleResultCallback<Void>)callback);
                }
            }
        });
    }

    @Override
    public <A extends Collection<? super T>> void into(final A target, final SingleResultCallback<A> callback) {
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<T>>(){

            public void onResult(AsyncBatchCursor<T> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    OperationIterable.this.loopCursor(batchCursor, new Block<T>(){

                        public void apply(T t) {
                            target.add(t);
                        }
                    }, (SingleResultCallback<Void>)((SingleResultCallback)new SingleResultCallback<Void>(){

                        public void onResult(Void result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                callback.onResult((Object)target, null);
                            }
                        }
                    }));
                }
            }
        });
    }

    @Override
    public void first(final SingleResultCallback<T> callback) {
        this.batchCursor(new SingleResultCallback<AsyncBatchCursor<T>>(){

            public void onResult(final AsyncBatchCursor<T> batchCursor, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    batchCursor.setBatchSize(1);
                    batchCursor.next(new SingleResultCallback<List<T>>(){

                        public void onResult(List<T> results, Throwable t) {
                            batchCursor.close();
                            if (t != null) {
                                callback.onResult(null, t);
                            } else if (results == null) {
                                callback.onResult(null, null);
                            } else {
                                callback.onResult(results.get(0), null);
                            }
                        }
                    });
                }
            }
        });
    }

    @Override
    public <U> MongoIterable<U> map(Function<T, U> mapper) {
        return new MappingIterable<T, U>(this, mapper);
    }

    @Override
    public OperationIterable<T> batchSize(int batchSize) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void batchCursor(SingleResultCallback<AsyncBatchCursor<T>> callback) {
        this.executor.execute(this.operation, this.readPreference, callback);
    }

    private void loopCursor(final AsyncBatchCursor<T> batchCursor, final Block<? super T> block, final SingleResultCallback<Void> callback) {
        batchCursor.next(new SingleResultCallback<List<T>>(){

            public void onResult(List<T> results, Throwable t) {
                if (t != null || results == null) {
                    batchCursor.close();
                    callback.onResult(null, t);
                } else {
                    try {
                        for (Object result : results) {
                            block.apply(result);
                        }
                        OperationIterable.this.loopCursor(batchCursor, block, (SingleResultCallback<Void>)callback);
                    }
                    catch (Throwable tr) {
                        batchCursor.close();
                        callback.onResult(null, tr);
                    }
                }
            }
        });
    }
}

