/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import java.util.List;
import org.bson.BsonDocument;

public class MongoDataKeyOptions {
    private final List<String> keyAltNames;
    private final BsonDocument masterKey;
    private final byte[] keyMaterial;

    public static Builder builder() {
        return new Builder();
    }

    public List<String> getKeyAltNames() {
        return this.keyAltNames;
    }

    public BsonDocument getMasterKey() {
        return this.masterKey;
    }

    public byte[] getKeyMaterial() {
        return this.keyMaterial;
    }

    private MongoDataKeyOptions(Builder builder) {
        this.keyAltNames = builder.keyAltNames;
        this.masterKey = builder.masterKey;
        this.keyMaterial = builder.keyMaterial;
    }

    public static class Builder {
        private List<String> keyAltNames;
        private BsonDocument masterKey;
        private byte[] keyMaterial;

        public Builder keyAltNames(List<String> keyAltNames) {
            this.keyAltNames = keyAltNames;
            return this;
        }

        public Builder masterKey(BsonDocument masterKey) {
            this.masterKey = masterKey;
            return this;
        }

        public Builder keyMaterial(byte[] keyMaterial) {
            this.keyMaterial = keyMaterial;
            return this;
        }

        public MongoDataKeyOptions build() {
            return new MongoDataKeyOptions(this);
        }
    }
}

