/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.crypt.capi;

import com.mongodb.crypt.capi.BinaryHolder;
import com.mongodb.crypt.capi.CAPI;
import com.mongodb.crypt.capi.CAPIHelper;
import com.mongodb.crypt.capi.CipherCallback;
import com.mongodb.crypt.capi.Logger;
import com.mongodb.crypt.capi.Loggers;
import com.mongodb.crypt.capi.MacCallback;
import com.mongodb.crypt.capi.MessageDigestCallback;
import com.mongodb.crypt.capi.MongoCrypt;
import com.mongodb.crypt.capi.MongoCryptContext;
import com.mongodb.crypt.capi.MongoCryptContextImpl;
import com.mongodb.crypt.capi.MongoCryptException;
import com.mongodb.crypt.capi.MongoCryptOptions;
import com.mongodb.crypt.capi.MongoDataKeyOptions;
import com.mongodb.crypt.capi.MongoExplicitEncryptOptions;
import com.mongodb.crypt.capi.SecureRandomCallback;
import com.sun.jna.Pointer;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.assertions.Assertions;

class MongoCryptImpl
implements MongoCrypt {
    private static final Logger LOGGER = Loggers.getLogger();
    private final CAPI.mongocrypt_t wrapped = CAPI.mongocrypt_new();
    private final LogCallback logCallback;
    private final CipherCallback aesCBC256EncryptCallback;
    private final CipherCallback aesCBC256DecryptCallback;
    private final MacCallback hmacSha512Callback;
    private final MacCallback hmacSha256Callback;
    private final MessageDigestCallback sha256Callback;
    private final SecureRandomCallback secureRandomCallback;
    private volatile boolean closed;

    MongoCryptImpl(MongoCryptOptions options) {
        if (this.wrapped == null) {
            throw new MongoCryptException("Unable to create new mongocrypt object");
        }
        this.logCallback = new LogCallback();
        boolean success = CAPI.mongocrypt_setopt_log_handler(this.wrapped, this.logCallback, null);
        if (!success) {
            this.throwExceptionFromStatus();
        }
        this.aesCBC256EncryptCallback = new CipherCallback("AES", "AES/CBC/NoPadding", 1);
        this.aesCBC256DecryptCallback = new CipherCallback("AES", "AES/CBC/NoPadding", 2);
        this.hmacSha512Callback = new MacCallback("HmacSHA512");
        this.hmacSha256Callback = new MacCallback("HmacSHA256");
        this.sha256Callback = new MessageDigestCallback("SHA-256");
        this.secureRandomCallback = new SecureRandomCallback(new SecureRandom());
        success = CAPI.mongocrypt_setopt_crypto_hooks(this.wrapped, this.aesCBC256EncryptCallback, this.aesCBC256DecryptCallback, this.secureRandomCallback, this.hmacSha512Callback, this.hmacSha256Callback, this.sha256Callback, null);
        if (!success) {
            this.throwExceptionFromStatus();
        }
        if (options.getLocalKmsProviderOptions() != null) {
            BinaryHolder localMasterKeyBinaryHolder = CAPIHelper.toBinary(options.getLocalKmsProviderOptions().getLocalMasterKey());
            Object object = null;
            try {
                success = CAPI.mongocrypt_setopt_kms_provider_local(this.wrapped, localMasterKeyBinaryHolder.getBinary());
                if (!success) {
                    this.throwExceptionFromStatus();
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (localMasterKeyBinaryHolder != null) {
                    MongoCryptImpl.$closeResource((Throwable)object, localMasterKeyBinaryHolder);
                }
            }
        }
        if (options.getAwsKmsProviderOptions() != null && !(success = CAPI.mongocrypt_setopt_kms_provider_aws(this.wrapped, new CAPI.cstring(options.getAwsKmsProviderOptions().getAccessKeyId()), -1, new CAPI.cstring(options.getAwsKmsProviderOptions().getSecretAccessKey()), -1))) {
            this.throwExceptionFromStatus();
        }
        if (options.getLocalSchemaMap() != null) {
            BsonDocument localSchemaMapDocument = new BsonDocument();
            for (Map.Entry entry : options.getLocalSchemaMap().entrySet()) {
                localSchemaMapDocument.put((String)entry.getKey(), (BsonValue)entry.getValue());
            }
            Throwable throwable = null;
            try (BinaryHolder localSchemaMapBinaryHolder = CAPIHelper.toBinary(localSchemaMapDocument);){
                success = CAPI.mongocrypt_setopt_schema_map(this.wrapped, localSchemaMapBinaryHolder.getBinary());
                if (!success) {
                    this.throwExceptionFromStatus();
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        if (!(success = CAPI.mongocrypt_init(this.wrapped))) {
            this.throwExceptionFromStatus();
        }
    }

    @Override
    public MongoCryptContext createEncryptionContext(String database, BsonDocument commandDocument) {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        Assertions.notNull((String)"database", (Object)database);
        Assertions.notNull((String)"commandDocument", (Object)commandDocument);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        try (BinaryHolder commandDocumentBinaryHolder = CAPIHelper.toBinary(commandDocument);){
            boolean success = CAPI.mongocrypt_ctx_encrypt_init(context, new CAPI.cstring(database), -1, commandDocumentBinaryHolder.getBinary());
            if (!success) {
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
            MongoCryptContextImpl mongoCryptContextImpl = new MongoCryptContextImpl(context);
            return mongoCryptContextImpl;
        }
    }

    @Override
    public MongoCryptContext createDecryptionContext(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        try (BinaryHolder documentBinaryHolder = CAPIHelper.toBinary(document);){
            boolean success = CAPI.mongocrypt_ctx_decrypt_init(context, documentBinaryHolder.getBinary());
            if (!success) {
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createDataKeyContext(String kmsProvider, MongoDataKeyOptions options) {
        boolean success;
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        if (kmsProvider.equals("aws")) {
            success = CAPI.mongocrypt_ctx_setopt_masterkey_aws(context, new CAPI.cstring(options.getMasterKey().getString((Object)"region").getValue()), -1, new CAPI.cstring(options.getMasterKey().getString((Object)"key").getValue()), -1);
        } else if (kmsProvider.equals("local")) {
            success = CAPI.mongocrypt_ctx_setopt_masterkey_local(context);
        } else {
            throw new IllegalArgumentException("Unsupported KMS provider " + kmsProvider);
        }
        if (!success) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        if (options.getKeyAltNames() != null) {
            for (String cur : options.getKeyAltNames()) {
                try (BinaryHolder keyAltNameBinaryHolder = CAPIHelper.toBinary(new BsonDocument("keyAltName", (BsonValue)new BsonString(cur)));){
                    success = CAPI.mongocrypt_ctx_setopt_key_alt_name(context, keyAltNameBinaryHolder.getBinary());
                    if (success) continue;
                    MongoCryptContextImpl.throwExceptionFromStatus(context);
                }
            }
        }
        if (!(success = CAPI.mongocrypt_ctx_datakey_init(context))) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        return new MongoCryptContextImpl(context);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public MongoCryptContext createExplicitEncryptionContext(BsonDocument document, MongoExplicitEncryptOptions options) {
        Assertions.isTrue((String)"open", (boolean)(this.closed == false));
        context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        if (options.getKeyId() != null) {
            keyIdBinaryHolder = CAPIHelper.toBinary(ByteBuffer.wrap(options.getKeyId().getData()));
            var6_5 = null;
            try {
                success = CAPI.mongocrypt_ctx_setopt_key_id(context, keyIdBinaryHolder.getBinary());
                if (success) ** GOTO lbl35
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
            catch (Throwable var7_7) {
                var6_5 = var7_7;
                throw var7_7;
            }
            finally {
                if (keyIdBinaryHolder != null) {
                    MongoCryptImpl.$closeResource(var6_5, keyIdBinaryHolder);
                }
            }
        } else if (options.getKeyAltName() != null) {
            keyAltNameBinaryHolder = CAPIHelper.toBinary(new BsonDocument("keyAltName", (BsonValue)new BsonString(options.getKeyAltName())));
            var6_5 = null;
            try {
                success = CAPI.mongocrypt_ctx_setopt_key_alt_name(context, keyAltNameBinaryHolder.getBinary());
                if (!success) {
                    MongoCryptContextImpl.throwExceptionFromStatus(context);
                }
            }
            catch (Throwable var7_8) {
                var6_5 = var7_8;
                throw var7_8;
            }
            finally {
                if (keyAltNameBinaryHolder != null) {
                    MongoCryptImpl.$closeResource(var6_5, keyAltNameBinaryHolder);
                }
            }
        }
        if (!(success = CAPI.mongocrypt_ctx_setopt_algorithm(context, new CAPI.cstring(options.getAlgorithm()), -1))) {
            MongoCryptContextImpl.throwExceptionFromStatus(context);
        }
        documentBinaryHolder = CAPIHelper.toBinary(document);
        var6_5 = null;
        try {
            success = CAPI.mongocrypt_ctx_explicit_encrypt_init(context, documentBinaryHolder.getBinary());
            if (!success) {
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
        }
        catch (Throwable var7_9) {
            var6_5 = var7_9;
            throw var7_9;
        }
        finally {
            if (documentBinaryHolder != null) {
                MongoCryptImpl.$closeResource(var6_5, documentBinaryHolder);
            }
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public MongoCryptContext createExplicitDecryptionContext(BsonDocument document) {
        Assertions.isTrue((String)"open", (!this.closed ? 1 : 0) != 0);
        CAPI.mongocrypt_ctx_t context = CAPI.mongocrypt_ctx_new(this.wrapped);
        if (context == null) {
            this.throwExceptionFromStatus();
        }
        try (BinaryHolder binaryHolder = CAPIHelper.toBinary(document);){
            boolean success = CAPI.mongocrypt_ctx_explicit_decrypt_init(context, binaryHolder.getBinary());
            if (!success) {
                MongoCryptContextImpl.throwExceptionFromStatus(context);
            }
        }
        return new MongoCryptContextImpl(context);
    }

    @Override
    public void close() {
        CAPI.mongocrypt_destroy(this.wrapped);
        this.closed = true;
    }

    private void throwExceptionFromStatus() {
        CAPI.mongocrypt_status_t status = CAPI.mongocrypt_status_new();
        CAPI.mongocrypt_status(this.wrapped, status);
        MongoCryptException e = new MongoCryptException(status);
        CAPI.mongocrypt_status_destroy(status);
        throw e;
    }

    static class LogCallback
    implements CAPI.mongocrypt_log_fn_t {
        LogCallback() {
        }

        @Override
        public void log(int level, CAPI.cstring message, int messageLength, Pointer ctx) {
            if (level == 0) {
                LOGGER.error(message.toString());
            }
            if (level == 1) {
                LOGGER.error(message.toString());
            }
            if (level == 2) {
                LOGGER.warn(message.toString());
            }
            if (level == 3) {
                LOGGER.info(message.toString());
            }
            if (level == 4) {
                LOGGER.trace(message.toString());
            }
        }
    }
}

