/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Block;
import com.mongodb.Function;
import com.mongodb.MongoNamespace;
import com.mongodb.OperationIterable;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.assertions.Assertions;
import com.mongodb.client.ChangeStreamIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Collation;
import com.mongodb.client.model.FullDocument;
import com.mongodb.operation.ChangeStreamOperation;
import com.mongodb.operation.OperationExecutor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bson.BsonDocument;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;

final class ChangeStreamIterableImpl<TResult>
implements ChangeStreamIterable<TResult> {
    private final MongoNamespace namespace;
    private final ReadPreference readPreference;
    private final ReadConcern readConcern;
    private final CodecRegistry codecRegistry;
    private final OperationExecutor executor;
    private final List<? extends Bson> pipeline;
    private final Class<TResult> resultClass;
    private Integer batchSize;
    private FullDocument fullDocument = FullDocument.DEFAULT;
    private Bson resumeToken;
    private long maxAwaitTimeMS;
    private Collation collation;

    ChangeStreamIterableImpl(MongoNamespace namespace, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, OperationExecutor executor, List<? extends Bson> pipeline, Class<TResult> resultClass) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.readPreference = Assertions.notNull("readPreference", readPreference);
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        this.executor = Assertions.notNull("executor", executor);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
    }

    @Override
    public ChangeStreamIterable<TResult> fullDocument(FullDocument fullDocument) {
        this.fullDocument = Assertions.notNull("fullDocument", fullDocument);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> resumeAfter(Bson resumeAfter) {
        this.resumeToken = Assertions.notNull("resumeAfter", resumeAfter);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> batchSize(int batchSize) {
        this.batchSize = Assertions.notNull("batchSize", batchSize);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public ChangeStreamIterable<TResult> collation(Collation collation) {
        this.collation = Assertions.notNull("collation", collation);
        return this;
    }

    @Override
    public MongoCursor<TResult> iterator() {
        return this.execute().iterator();
    }

    @Override
    public TResult first() {
        return this.execute().first();
    }

    @Override
    public <U> MongoIterable<U> map(Function<TResult, U> mapper) {
        return this.execute().map(mapper);
    }

    @Override
    public void forEach(Block<? super TResult> block) {
        this.execute().forEach(block);
    }

    @Override
    public <A extends Collection<? super TResult>> A into(A target) {
        return this.execute().into(target);
    }

    private MongoIterable<TResult> execute() {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        ChangeStreamOperation<TResult> changeStreamOperation = new ChangeStreamOperation<TResult>(this.namespace, this.fullDocument, aggregateList, this.codecRegistry.get(this.resultClass)).maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS).batchSize(this.batchSize).readConcern(this.readConcern).collation(this.collation);
        if (this.resumeToken != null) {
            changeStreamOperation.resumeAfter(this.resumeToken.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return new OperationIterable(changeStreamOperation, this.readPreference, this.executor);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            aggregateList.add(bson.toBsonDocument(BsonDocument.class, this.codecRegistry));
        }
        return aggregateList;
    }
}

