/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

final class TypeParameterMap {
    private final Map<Integer, Integer> fieldToClassParamIndexMap;

    static Builder builder() {
        return new Builder();
    }

    Map<Integer, Integer> getFieldToClassParamIndexMap() {
        return this.fieldToClassParamIndexMap;
    }

    boolean hasTypeParameters() {
        return !this.fieldToClassParamIndexMap.isEmpty();
    }

    public String toString() {
        return "TypeParameterMap{fieldToClassParamIndexMap=" + this.fieldToClassParamIndexMap + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TypeParameterMap that = (TypeParameterMap)o;
        return this.getFieldToClassParamIndexMap().equals(that.getFieldToClassParamIndexMap());
    }

    public int hashCode() {
        return this.getFieldToClassParamIndexMap().hashCode();
    }

    private TypeParameterMap(Map<Integer, Integer> fieldToClassParamIndexMap) {
        this.fieldToClassParamIndexMap = Collections.unmodifiableMap(fieldToClassParamIndexMap);
    }

    static final class Builder {
        private final Map<Integer, Integer> fieldToClassParamIndexMap = new HashMap<Integer, Integer>();

        private Builder() {
        }

        Builder addIndex(int classTypeParameterIndex) {
            this.fieldToClassParamIndexMap.put(-1, classTypeParameterIndex);
            return this;
        }

        Builder addIndex(int fieldTypeParameterIndex, int classTypeParameterIndex) {
            this.fieldToClassParamIndexMap.put(fieldTypeParameterIndex, classTypeParameterIndex);
            return this;
        }

        TypeParameterMap build() {
            if (this.fieldToClassParamIndexMap.size() > 1 && this.fieldToClassParamIndexMap.containsKey(-1)) {
                throw new IllegalStateException("You cannot have a generic field that also has type parameters.");
            }
            return new TypeParameterMap(this.fieldToClassParamIndexMap);
        }
    }
}

