/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bson.assertions.Assertions;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.codecs.pojo.ClassModel;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.Convention;
import org.bson.codecs.pojo.DiscriminatorLookup;
import org.bson.codecs.pojo.PojoCodec;

public final class PojoCodecProvider
implements CodecProvider {
    private final Map<Class<?>, ClassModel<?>> classModels;
    private final Set<String> packages;
    private final List<Convention> conventions;
    private final DiscriminatorLookup discriminatorLookup;

    private PojoCodecProvider(Map<Class<?>, ClassModel<?>> classModels, Set<String> packages, List<Convention> conventions) {
        this.classModels = classModels;
        this.packages = packages;
        this.conventions = conventions;
        this.discriminatorLookup = new DiscriminatorLookup(classModels, packages);
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        return this.getPojoCodec(clazz, registry);
    }

    <T> PojoCodec<T> getPojoCodec(Class<T> clazz, CodecRegistry registry) {
        ClassModel<Object> classModel = this.classModels.get(clazz);
        if (classModel != null || clazz.getPackage() != null && this.packages.contains(clazz.getPackage().getName())) {
            if (classModel == null) {
                classModel = PojoCodecProvider.createClassModel(clazz, this.conventions);
            }
            return new PojoCodec(classModel, this, registry, this.discriminatorLookup);
        }
        return null;
    }

    private static <T> ClassModel<T> createClassModel(Class<T> clazz, List<Convention> conventions) {
        ClassModelBuilder<T> builder = ClassModel.builder(clazz);
        if (conventions != null) {
            builder.conventions(conventions);
        }
        return builder.build();
    }

    public static final class Builder {
        private final Set<String> packages = new HashSet<String>();
        private final Map<Class<?>, ClassModel<?>> classModels = new HashMap();
        private final List<Class<?>> clazzes = new ArrayList();
        private List<Convention> conventions = null;

        public PojoCodecProvider build() {
            List<Convention> immutableConventions = this.conventions != null ? Collections.unmodifiableList(new ArrayList<Convention>(this.conventions)) : null;
            for (Class<?> clazz : this.clazzes) {
                if (this.classModels.containsKey(clazz)) continue;
                this.register(PojoCodecProvider.createClassModel(clazz, immutableConventions));
            }
            return new PojoCodecProvider(this.classModels, this.packages, immutableConventions);
        }

        public Builder conventions(List<Convention> conventions) {
            this.conventions = Assertions.notNull("conventions", conventions);
            return this;
        }

        public Builder register(Class<?> ... classes) {
            this.clazzes.addAll(Arrays.asList(classes));
            return this;
        }

        public Builder register(ClassModel<?> ... classModels) {
            Assertions.notNull("classModels", classModels);
            for (ClassModel<?> classModel : classModels) {
                this.classModels.put(classModel.getType(), classModel);
            }
            return this;
        }

        public Builder register(String ... packageNames) {
            Assertions.notNull("packageNames", packageNames);
            for (String name : packageNames) {
                this.packages.add(name);
            }
            return this;
        }

        private Builder() {
        }
    }
}

