/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.MongoSocketWriteException;
import com.mongodb.ServerAddress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;

class KeyManagementService {
    private final SSLContext sslContext;
    private final int port;
    private int timeoutMillis;

    KeyManagementService(SSLContext sslContext, int port, int timeoutMillis) {
        this.sslContext = sslContext;
        this.port = port;
        this.timeoutMillis = timeoutMillis;
    }

    public InputStream stream(String host, ByteBuffer message) {
        try {
            Socket socket = this.sslContext.getSocketFactory().createSocket();
            socket.setSoTimeout(this.timeoutMillis);
            socket.connect(new InetSocketAddress(InetAddress.getByName(host), this.port), this.timeoutMillis);
            OutputStream outputStream = socket.getOutputStream();
            byte[] bytes = new byte[message.remaining()];
            message.get(bytes);
            outputStream.write(bytes);
            return socket.getInputStream();
        }
        catch (IOException e) {
            throw new MongoSocketWriteException("Exception sending message to Key Management Service", new ServerAddress(host, this.port), (Throwable)e);
        }
    }

    public int getPort() {
        return this.port;
    }
}

