/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client.internal;

import com.mongodb.Block;
import com.mongodb.ConnectionString;
import com.mongodb.MongoClientException;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.ReadConcern;
import com.mongodb.ReadPreference;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.connection.ClusterSettings;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.bson.RawBsonDocument;
import org.bson.conversions.Bson;

class CommandMarker
implements Closeable {
    private MongoClient client;
    private final ProcessBuilder processBuilder;
    private boolean active;

    CommandMarker(Map<String, Object> options) {
        String connectionString = options.containsKey("mongocryptdURI") ? (String)options.get("mongocryptdURI") : "mongodb://localhost:27020";
        this.client = MongoClients.create(MongoClientSettings.builder().applyConnectionString(new ConnectionString(connectionString)).applyToClusterSettings(new Block<ClusterSettings.Builder>(){

            @Override
            public void apply(ClusterSettings.Builder builder) {
                builder.serverSelectionTimeout(1L, TimeUnit.SECONDS);
            }
        }).build());
        this.active = false;
        if (!options.containsKey("mongocryptdBypassSpawn") || !((Boolean)options.get("mongocryptdBypassSpawn")).booleanValue()) {
            List<String> spawnArgs = this.createSpawnArgs(options);
            this.processBuilder = new ProcessBuilder(spawnArgs);
        } else {
            this.processBuilder = null;
        }
    }

    RawBsonDocument mark(String databaseName, RawBsonDocument command) {
        this.spawnIfNecesary();
        try {
            try {
                return this.executeCommand(databaseName, command);
            }
            catch (MongoTimeoutException e) {
                this.spawnIfNecesary();
                return this.executeCommand(databaseName, command);
            }
        }
        catch (MongoException e) {
            throw this.wrapInClientException(e);
        }
    }

    @Override
    public void close() {
        this.client.close();
    }

    private List<String> createSpawnArgs(Map<String, Object> options) {
        ArrayList<String> spawnArgs = new ArrayList<String>();
        String path = options.containsKey("mongocryptdPath") ? (String)options.get("mongocryptdPath") : "mongocryptd";
        spawnArgs.add(path);
        if (options.containsKey("mongocryptdSpawnArgs")) {
            spawnArgs.addAll((List)options.get("mongocryptdSpawnArgs"));
        }
        if (!spawnArgs.contains("--idleShutdownTimeoutSecs")) {
            spawnArgs.add("--idleShutdownTimeoutSecs");
            spawnArgs.add("60");
        }
        return spawnArgs;
    }

    private RawBsonDocument executeCommand(String databaseName, RawBsonDocument markablecommand) {
        return this.client.getDatabase(databaseName).withReadConcern(ReadConcern.DEFAULT).withReadPreference(ReadPreference.primary()).runCommand((Bson)markablecommand, RawBsonDocument.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void spawnIfNecesary() {
        block6: {
            try {
                if (this.processBuilder == null) break block6;
                CommandMarker commandMarker = this;
                synchronized (commandMarker) {
                    if (!this.active) {
                        this.processBuilder.start();
                        this.active = true;
                    }
                }
            }
            catch (IOException e) {
                throw new MongoClientException("Exception starting mongocryptd process", e);
            }
        }
    }

    private MongoClientException wrapInClientException(MongoException e) {
        return new MongoClientException("Exception in encryption library: " + e.getMessage(), e);
    }
}

