/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.operation;

import com.mongodb.MongoNamespace;
import com.mongodb.ServerCursor;
import com.mongodb.assertions.Assertions;
import com.mongodb.async.AsyncBatchCursor;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.binding.AsyncConnectionSource;
import com.mongodb.connection.AsyncConnection;
import com.mongodb.connection.QueryResult;
import com.mongodb.internal.async.ErrorHandlingResultCallback;
import com.mongodb.operation.CursorHelper;
import java.util.Collections;
import java.util.List;
import org.bson.codecs.Decoder;

class AsyncQueryBatchCursor<T>
implements AsyncBatchCursor<T> {
    private final MongoNamespace namespace;
    private final int limit;
    private final Decoder<T> decoder;
    private volatile AsyncConnectionSource connectionSource;
    private volatile QueryResult<T> firstBatch;
    private volatile int batchSize;
    private volatile ServerCursor cursor;
    private volatile int count;
    private volatile boolean closed;

    AsyncQueryBatchCursor(QueryResult<T> firstBatch, int limit, int batchSize, Decoder<T> decoder) {
        this(firstBatch, limit, batchSize, decoder, null);
    }

    AsyncQueryBatchCursor(QueryResult<T> firstBatch, int limit, int batchSize, Decoder<T> decoder, AsyncConnectionSource connectionSource) {
        this.namespace = firstBatch.getNamespace();
        this.firstBatch = firstBatch;
        this.limit = limit;
        this.batchSize = batchSize;
        this.decoder = decoder;
        this.cursor = firstBatch.getCursor();
        if (this.cursor != null) {
            Assertions.notNull("connectionSource", connectionSource);
        }
        this.connectionSource = connectionSource != null ? connectionSource.retain() : null;
        this.count += firstBatch.getResults().size();
        if (this.limitReached()) {
            this.killCursor();
        }
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.killCursor();
        }
    }

    @Override
    public void next(SingleResultCallback<List<T>> callback) {
        Assertions.isTrue("open", !this.closed);
        if (this.firstBatch != null && !this.firstBatch.getResults().isEmpty()) {
            List<T> results = this.firstBatch.getResults();
            this.firstBatch = null;
            callback.onResult(results, null);
        } else if (this.cursor == null) {
            this.close();
            callback.onResult(null, null);
        } else {
            this.getMore(callback);
        }
    }

    @Override
    public void setBatchSize(int batchSize) {
        Assertions.isTrue("open", !this.closed);
        this.batchSize = batchSize;
    }

    @Override
    public int getBatchSize() {
        Assertions.isTrue("open", !this.closed);
        return this.batchSize;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private boolean limitReached() {
        return this.limit != 0 && this.count >= this.limit;
    }

    private void getMore(final SingleResultCallback<List<T>> callback) {
        this.connectionSource.getConnection(new SingleResultCallback<AsyncConnection>(){

            @Override
            public void onResult(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    connection.getMoreAsync(AsyncQueryBatchCursor.this.namespace, AsyncQueryBatchCursor.this.cursor.getId(), CursorHelper.getNumberToReturn(AsyncQueryBatchCursor.this.limit, AsyncQueryBatchCursor.this.batchSize, AsyncQueryBatchCursor.this.count), AsyncQueryBatchCursor.this.decoder, new QueryResultSingleResultCallback(connection, callback));
                }
            }
        });
    }

    private void killCursor() {
        if (this.cursor != null) {
            final ServerCursor localCursor = this.cursor;
            final AsyncConnectionSource localConnectionSource = this.connectionSource;
            this.cursor = null;
            this.connectionSource = null;
            localConnectionSource.getConnection(new SingleResultCallback<AsyncConnection>(){

                @Override
                public void onResult(final AsyncConnection connection, Throwable connectionException) {
                    if (connection != null) {
                        connection.killCursorAsync(AsyncQueryBatchCursor.this.namespace, Collections.singletonList(localCursor.getId()), new SingleResultCallback<Void>(){

                            @Override
                            public void onResult(Void result, Throwable t) {
                                connection.release();
                                localConnectionSource.release();
                            }
                        });
                    }
                }
            });
        } else if (this.connectionSource != null) {
            this.connectionSource.release();
            this.connectionSource = null;
        }
    }

    private class QueryResultSingleResultCallback
    implements SingleResultCallback<QueryResult<T>> {
        private final AsyncConnection connection;
        private final SingleResultCallback<List<T>> callback;

        public QueryResultSingleResultCallback(AsyncConnection connection, SingleResultCallback<List<T>> callback) {
            this.connection = connection;
            this.callback = ErrorHandlingResultCallback.errorHandlingCallback(callback);
        }

        @Override
        public void onResult(QueryResult<T> result, Throwable t) {
            if (t != null) {
                this.connection.release();
                AsyncQueryBatchCursor.this.close();
                this.callback.onResult(null, t);
            } else if (result.getResults().isEmpty() && result.getCursor() != null) {
                this.connection.getMoreAsync(AsyncQueryBatchCursor.this.namespace, AsyncQueryBatchCursor.this.cursor.getId(), CursorHelper.getNumberToReturn(AsyncQueryBatchCursor.this.limit, AsyncQueryBatchCursor.this.batchSize, AsyncQueryBatchCursor.this.count), AsyncQueryBatchCursor.this.decoder, this);
            } else {
                AsyncQueryBatchCursor.this.cursor = result.getCursor();
                AsyncQueryBatchCursor.this.count = AsyncQueryBatchCursor.this.count + result.getResults().size();
                if (AsyncQueryBatchCursor.this.limitReached()) {
                    AsyncQueryBatchCursor.this.killCursor();
                }
                this.connection.release();
                if (result.getResults().isEmpty()) {
                    this.callback.onResult(null, null);
                } else {
                    this.callback.onResult(result.getResults(), null);
                }
            }
        }
    }
}

