/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.client;

import com.mongodb.MongoNamespace;
import com.mongodb.ReadPreference;
import com.mongodb.WriteConcern;
import com.mongodb.annotations.ThreadSafe;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.DistinctIterable;
import com.mongodb.client.FindIterable;
import com.mongodb.client.ListIndexesIterable;
import com.mongodb.client.MapReduceIterable;
import com.mongodb.client.model.BulkWriteOptions;
import com.mongodb.client.model.CountOptions;
import com.mongodb.client.model.CreateIndexOptions;
import com.mongodb.client.model.FindOneAndDeleteOptions;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.FindOneAndUpdateOptions;
import com.mongodb.client.model.InsertManyOptions;
import com.mongodb.client.model.RenameCollectionOptions;
import com.mongodb.client.model.UpdateOptions;
import com.mongodb.client.model.WriteModel;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import java.util.List;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistry;

@ThreadSafe
public interface MongoCollection<T> {
    public MongoNamespace getNamespace();

    public Class<T> getDefaultClass();

    public CodecRegistry getCodecRegistry();

    public ReadPreference getReadPreference();

    public WriteConcern getWriteConcern();

    public <C> MongoCollection<C> withDefaultClass(Class<C> var1);

    public MongoCollection<T> withCodecRegistry(CodecRegistry var1);

    public MongoCollection<T> withReadPreference(ReadPreference var1);

    public MongoCollection<T> withWriteConcern(WriteConcern var1);

    public long count();

    public long count(Object var1);

    public long count(Object var1, CountOptions var2);

    public <C> DistinctIterable<C> distinct(String var1, Class<C> var2);

    public FindIterable<T> find();

    public <C> FindIterable<C> find(Class<C> var1);

    public FindIterable<T> find(Object var1);

    public <C> FindIterable<C> find(Object var1, Class<C> var2);

    public AggregateIterable<Document> aggregate(List<?> var1);

    public <C> AggregateIterable<C> aggregate(List<?> var1, Class<C> var2);

    public MapReduceIterable<Document> mapReduce(String var1, String var2);

    public <C> MapReduceIterable<C> mapReduce(String var1, String var2, Class<C> var3);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends T>> var1);

    public BulkWriteResult bulkWrite(List<? extends WriteModel<? extends T>> var1, BulkWriteOptions var2);

    public void insertOne(T var1);

    public void insertMany(List<? extends T> var1);

    public void insertMany(List<? extends T> var1, InsertManyOptions var2);

    public DeleteResult deleteOne(Object var1);

    public DeleteResult deleteMany(Object var1);

    public UpdateResult replaceOne(Object var1, T var2);

    public UpdateResult replaceOne(Object var1, T var2, UpdateOptions var3);

    public UpdateResult updateOne(Object var1, Object var2);

    public UpdateResult updateOne(Object var1, Object var2, UpdateOptions var3);

    public UpdateResult updateMany(Object var1, Object var2);

    public UpdateResult updateMany(Object var1, Object var2, UpdateOptions var3);

    public T findOneAndDelete(Object var1);

    public T findOneAndDelete(Object var1, FindOneAndDeleteOptions var2);

    public T findOneAndReplace(Object var1, T var2);

    public T findOneAndReplace(Object var1, T var2, FindOneAndReplaceOptions var3);

    public T findOneAndUpdate(Object var1, Object var2);

    public T findOneAndUpdate(Object var1, Object var2, FindOneAndUpdateOptions var3);

    public void dropCollection();

    public void createIndex(Object var1);

    public void createIndex(Object var1, CreateIndexOptions var2);

    public ListIndexesIterable<Document> listIndexes();

    public <C> ListIndexesIterable<C> listIndexes(Class<C> var1);

    public void dropIndex(String var1);

    public void dropIndexes();

    public void renameCollection(MongoNamespace var1);

    public void renameCollection(MongoNamespace var1, RenameCollectionOptions var2);
}

