/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimplePool<T> {
    protected final String _name;
    protected final int _size;
    protected final List<T> _avail = new ArrayList<T>();
    protected final Set<T> _out = new HashSet<T>();
    private final Semaphore _sem;
    private boolean _closed;

    public SimplePool(String name, int size) {
        this._name = name;
        this._size = size;
        this._sem = new Semaphore(size);
    }

    protected abstract T createNew();

    public void cleanup(T t) {
    }

    protected int pick(int recommended, boolean couldCreate) {
        return recommended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void done(T t) {
        SimplePool simplePool = this;
        synchronized (simplePool) {
            if (this._closed) {
                this.cleanup(t);
                return;
            }
            this.assertConditions();
            if (!this._out.remove(t)) {
                throw new RuntimeException("trying to put something back in the pool wasn't checked out");
            }
            this._avail.add(t);
        }
        this._sem.release();
    }

    private void assertConditions() {
        assert (this.getTotal() <= this.getMaxSize());
    }

    public void remove(T t) {
        this.done(t);
    }

    public T get() throws InterruptedException {
        return this.get(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get(long waitTime) throws InterruptedException {
        if (!this.permitAcquired(waitTime)) {
            return null;
        }
        SimplePool simplePool = this;
        synchronized (simplePool) {
            this.assertConditions();
            int toTake = this.pick(this._avail.size() - 1, this.getTotal() < this.getMaxSize());
            T t = toTake >= 0 ? this._avail.remove(toTake) : this.createNewAndReleasePermitIfFailure();
            this._out.add(t);
            return t;
        }
    }

    private T createNewAndReleasePermitIfFailure() {
        try {
            T newMember = this.createNew();
            if (newMember == null) {
                throw new IllegalStateException("null pool members are not allowed");
            }
            return newMember;
        }
        catch (RuntimeException e) {
            this._sem.release();
            throw e;
        }
        catch (Error e) {
            this._sem.release();
            throw e;
        }
    }

    private boolean permitAcquired(long waitTime) throws InterruptedException {
        if (waitTime > 0L) {
            return this._sem.tryAcquire(waitTime, TimeUnit.MILLISECONDS);
        }
        if (waitTime < 0L) {
            this._sem.acquire();
            return true;
        }
        return this._sem.tryAcquire();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        List<T> list = this._avail;
        synchronized (list) {
            this._closed = true;
            for (T t : this._avail) {
                this.cleanup(t);
            }
            this._avail.clear();
            this._out.clear();
        }
    }

    public String getName() {
        return this._name;
    }

    public synchronized int getTotal() {
        return this._avail.size() + this._out.size();
    }

    public synchronized int getInUse() {
        return this._out.size();
    }

    public synchronized int getAvailable() {
        return this._avail.size();
    }

    public int getMaxSize() {
        return this._size;
    }

    public synchronized String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("pool: ").append(this._name).append(" maxToKeep: ").append(this._size).append(" avail ").append(this._avail.size()).append(" out ").append(this._out.size());
        return buf.toString();
    }
}

