/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;

public class WriteConcern {
    public static final WriteConcern NONE = new WriteConcern(-1);
    public static final WriteConcern NORMAL = new WriteConcern(0);
    public static final WriteConcern SAFE = new WriteConcern(1);
    public static final WriteConcern MAJORITY = new Majority();
    public static final WriteConcern FSYNC_SAFE = new WriteConcern(true);
    public static final WriteConcern JOURNAL_SAFE = new WriteConcern(1, 0, false, true);
    public static final WriteConcern REPLICAS_SAFE = new WriteConcern(2);
    private static Map<String, WriteConcern> _namedConcerns = null;
    Object _wValue;
    final int _wtimeout;
    final boolean _fsync;
    final boolean _j;
    final boolean _continueOnErrorInsert;

    public WriteConcern() {
        this(0);
    }

    public WriteConcern(int w) {
        this(w, 0, false);
    }

    public WriteConcern(String w) {
        this(w, 0, false, false);
    }

    public WriteConcern(String w, boolean j) {
        this(w, 0, false, j);
    }

    public WriteConcern(int w, int wtimeout) {
        this(w, wtimeout, false);
    }

    public WriteConcern(boolean fsync) {
        this(1, 0, fsync);
    }

    public WriteConcern(int w, int wtimeout, boolean fsync) {
        this(w, wtimeout, fsync, false);
    }

    public WriteConcern(int w, int wtimeout, boolean fsync, boolean j) {
        this._wValue = w;
        this._wtimeout = wtimeout;
        this._fsync = fsync;
        this._j = j;
        this._continueOnErrorInsert = false;
    }

    public WriteConcern(int w, int wtimeout, boolean fsync, boolean j, boolean continueInsertOnError) {
        this._wValue = w;
        this._wtimeout = wtimeout;
        this._fsync = fsync;
        this._j = j;
        this._continueOnErrorInsert = continueInsertOnError;
    }

    public WriteConcern(String w, int wtimeout, boolean fsync, boolean j) {
        this._wValue = w;
        this._wtimeout = wtimeout;
        this._fsync = fsync;
        this._j = j;
        this._continueOnErrorInsert = false;
    }

    public WriteConcern(String w, int wtimeout, boolean fsync, boolean j, Boolean continueInsertOnError) {
        this._wValue = w;
        this._wtimeout = wtimeout;
        this._fsync = fsync;
        this._j = j;
        this._continueOnErrorInsert = continueInsertOnError;
    }

    public BasicDBObject getCommand() {
        BasicDBObject _command = new BasicDBObject("getlasterror", (Object)1);
        if (this._wValue instanceof Integer && (Integer)this._wValue > 0 || this._wValue instanceof String && this._wValue != null) {
            _command.put("w", this._wValue);
            _command.put("wtimeout", (Object)this._wtimeout);
        }
        if (this._fsync) {
            _command.put("fsync", (Object)true);
        }
        if (this._j) {
            _command.put("j", (Object)true);
        }
        return _command;
    }

    public int getW() {
        if (this._wValue instanceof Integer) {
            return (Integer)this._wValue;
        }
        return -999;
    }

    public String getWString() {
        return this._wValue.toString();
    }

    public int getWtimeout() {
        return this._wtimeout;
    }

    public boolean fsync() {
        return this._fsync;
    }

    public boolean j() {
        return this._j;
    }

    public boolean continueOnErrorForInsert() {
        return this._continueOnErrorInsert;
    }

    public boolean raiseNetworkErrors() {
        return (Integer)this._wValue >= 0;
    }

    public boolean callGetLastError() {
        return (Integer)this._wValue > 0;
    }

    public static WriteConcern valueOf(String name) {
        if (_namedConcerns == null) {
            HashMap<String, WriteConcern> newMap = new HashMap<String, WriteConcern>(8, 1.0f);
            for (Field f : WriteConcern.class.getFields()) {
                if (!Modifier.isStatic(f.getModifiers()) || !f.getType().equals(WriteConcern.class)) continue;
                try {
                    newMap.put(f.getName().toLowerCase(), (WriteConcern)f.get(null));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            _namedConcerns = newMap;
        }
        return _namedConcerns.get(name.toLowerCase());
    }

    public String toString() {
        return "WriteConcern " + this.getCommand() + " / (Continue Inserting on Errors? " + this.continueOnErrorForInsert() + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteConcern that = (WriteConcern)o;
        return this._fsync == that._fsync && this._wValue == that._wValue && this._wtimeout == that._wtimeout && this._j == that._j && this._continueOnErrorInsert == that._continueOnErrorInsert;
    }

    public Object getWValue() {
        return this._wValue;
    }

    public WriteConcern withW(String mode) {
        return this._instance(mode, this._wtimeout, this._fsync, this._j, this._continueOnErrorInsert);
    }

    public WriteConcern withW(int w) {
        return this._instance(w, this._wtimeout, this._fsync, this._j, this._continueOnErrorInsert);
    }

    public WriteConcern withJ(boolean j) {
        return this._instance(this._wValue, this._wtimeout, this._fsync, this._j, this._continueOnErrorInsert);
    }

    public WriteConcern withContinueOnErrorForInsert(boolean cont) {
        return this._instance(this._wValue, this._wtimeout, this._fsync, this._j, cont);
    }

    public WriteConcern withFsync(boolean fsync) {
        return this._instance(this._wValue, this._wtimeout, fsync, this._j, this._continueOnErrorInsert);
    }

    protected WriteConcern _instance(Object wValue, int wtimeout, boolean fsync, boolean j, boolean cont) {
        if (wValue instanceof Integer) {
            return new WriteConcern((Integer)wValue, wtimeout, fsync, j, cont);
        }
        if (wValue instanceof String) {
            return new WriteConcern((String)wValue, wtimeout, fsync, j, (Boolean)cont);
        }
        throw new IllegalArgumentException("W must be a String or Integer.");
    }

    public static Majority majorityWriteConcern(int wtimeout, boolean fsync, boolean j) {
        return new Majority(wtimeout, fsync, j);
    }

    public static class Majority
    extends WriteConcern {
        public Majority() {
            super("majority", 0, false, false);
        }

        public Majority(int wtimeout, boolean fsync, boolean j) {
            super("majority", wtimeout, fsync, j);
        }

        public String toString() {
            return "[Majority] WriteConcern " + this.getCommand();
        }
    }
}

