/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.Bytes;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBPointer;
import com.mongodb.DBRefBase;
import com.mongodb.Mongo;
import com.mongodb.WriteConcern;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BSONEncoder;
import org.bson.BSONObject;
import org.bson.io.PoolOutputBuffer;
import org.bson.types.ObjectId;

class OutMessage
extends BSONEncoder {
    static AtomicInteger ID = new AtomicInteger(1);
    private Mongo _mongo;
    private PoolOutputBuffer _buffer;
    private int _id;
    private int _queryOptions = 0;

    static OutMessage query(Mongo m, int options, String ns, int numToSkip, int batchSize, DBObject query, DBObject fields) {
        OutMessage out = new OutMessage(m, 2004);
        out._appendQuery(options, ns, numToSkip, batchSize, query, fields);
        return out;
    }

    OutMessage(Mongo m) {
        this._mongo = m;
        this._buffer = this._mongo == null ? new PoolOutputBuffer() : this._mongo._bufferPool.get();
        this.set(this._buffer);
    }

    OutMessage(Mongo m, int op) {
        this(m);
        this.reset(op);
    }

    private void _appendQuery(int options, String ns, int numToSkip, int batchSize, DBObject query, DBObject fields) {
        this._queryOptions = options;
        this.writeInt(options);
        this.writeCString(ns);
        this.writeInt(numToSkip);
        this.writeInt(batchSize);
        this.putObject(query);
        if (fields != null) {
            this.putObject(fields);
        }
    }

    private void reset(int op) {
        this.done();
        this._buffer.reset();
        this.set(this._buffer);
        this._id = ID.getAndIncrement();
        this.writeInt(0);
        this.writeInt(this._id);
        this.writeInt(0);
        this.writeInt(op);
    }

    void prepare() {
        this._buffer.writeInt(0, this._buffer.size());
    }

    protected boolean handleSpecialObjects(String name, BSONObject o) {
        if (o == null) {
            return false;
        }
        if (o instanceof DBCollection) {
            DBCollection c = (DBCollection)((Object)o);
            this.putDBPointer(name, c.getName(), Bytes.COLLECTION_REF_ID);
            return true;
        }
        if (name != null && o instanceof DBPointer) {
            DBPointer r = (DBPointer)((Object)o);
            this.putDBPointer(name, r._ns, (ObjectId)r._id);
            return true;
        }
        return false;
    }

    protected boolean putSpecial(String name, Object val) {
        if (val instanceof DBPointer) {
            DBPointer r = (DBPointer)val;
            this.putDBPointer(name, r._ns, (ObjectId)r._id);
            return true;
        }
        if (val instanceof DBRefBase) {
            this.putDBRef(name, (DBRefBase)val);
            return true;
        }
        return false;
    }

    protected void putDBPointer(String name, String ns, ObjectId oid) {
        this._put((byte)12, name);
        this._putValueString(ns);
        this._buf.writeInt(oid._time());
        this._buf.writeInt(oid._machine());
        this._buf.writeInt(oid._inc());
    }

    protected void putDBRef(String name, DBRefBase ref) {
        this._put((byte)3, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putObjectField("$ref", ref.getRef());
        this._putObjectField("$id", ref.getId());
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    void append(String db, WriteConcern c) {
        this._id = ID.getAndIncrement();
        int loc = this.size();
        this.writeInt(0);
        this.writeInt(this._id);
        this.writeInt(0);
        this.writeInt(2004);
        this._appendQuery(0, db + ".$cmd", 0, -1, c.getCommand(), null);
        this._buf.writeInt(loc, this.size() - loc);
    }

    void pipe(OutputStream out) throws IOException {
        this._buffer.pipe(out);
    }

    int size() {
        return this._buffer.size();
    }

    byte[] toByteArray() {
        return this._buffer.toByteArray();
    }

    void doneWithMessage() {
        if (this._buffer != null && this._mongo != null) {
            this._mongo._bufferPool.done(this._buffer);
        }
        this._buffer = null;
        this._mongo = null;
    }

    boolean hasOption(int option) {
        return (this._queryOptions & option) != 0;
    }

    int getId() {
        return this._id;
    }
}

