/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBPortPool;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.OutMessage;
import com.mongodb.Response;
import com.mongodb.util.ThreadUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DBPort {
    public static final int PORT = 27017;
    static final boolean USE_NAGLE = false;
    static final long CONN_RETRY_TIME_MS = 15000L;
    final int _hashCode;
    final InetSocketAddress _addr;
    final DBPortPool _pool;
    final MongoOptions _options;
    final Logger _logger;
    private Socket _socket;
    private InputStream _in;
    private OutputStream _out;
    private boolean _inauth = false;
    private Map<DB, Boolean> _authed = Collections.synchronizedMap(new WeakHashMap());
    private static Logger _rootLogger = Logger.getLogger("com.mongodb.port");

    public DBPort(InetSocketAddress addr) throws IOException {
        this(addr, null, new MongoOptions());
    }

    DBPort(InetSocketAddress addr, DBPortPool pool, MongoOptions options) throws IOException {
        this._options = options;
        this._addr = addr;
        this._pool = pool;
        this._hashCode = this._addr.hashCode();
        this._logger = Logger.getLogger(_rootLogger.getName() + "." + addr.toString());
    }

    Response call(OutMessage msg, DBCollection coll) throws IOException {
        return this.go(msg, coll);
    }

    void say(OutMessage msg) throws IOException {
        this.go(msg, null);
    }

    private synchronized Response go(OutMessage msg, DBCollection coll) throws IOException {
        if (this._socket == null) {
            this._open();
        }
        try {
            msg.prepare();
            msg.pipe(this._out);
            if (this._pool != null) {
                this._pool._everWorked = true;
            }
            if (coll == null) {
                return null;
            }
            return new Response(coll, this._in);
        }
        catch (IOException ioe) {
            this.close();
            throw ioe;
        }
    }

    public synchronized void ensureOpen() throws IOException {
        if (this._socket != null) {
            return;
        }
        this._open();
    }

    void _open() throws IOException {
        long sleepTime = 100L;
        long start = System.currentTimeMillis();
        while (true) {
            IOException lastError = null;
            try {
                this._socket = new Socket();
                this._socket.connect(this._addr, this._options.connectTimeout);
                this._socket.setTcpNoDelay(true);
                this._socket.setSoTimeout(this._options.socketTimeout);
                this._in = new BufferedInputStream(this._socket.getInputStream());
                this._out = this._socket.getOutputStream();
                return;
            }
            catch (IOException ioe) {
                lastError = new IOException("couldn't connect to [" + this._addr + "] bc:" + ioe);
                this._logger.log(Level.INFO, "connect fail to : " + this._addr, ioe);
                if (!this._options.autoConnectRetry || this._pool != null && !this._pool._everWorked) {
                    throw lastError;
                }
                long sleptSoFar = System.currentTimeMillis() - start;
                if (sleptSoFar >= 15000L) {
                    throw lastError;
                }
                if (sleepTime + sleptSoFar > 15000L) {
                    sleepTime = 15000L - sleptSoFar;
                }
                this._logger.severe("going to sleep and retry.  total sleep time after = " + (sleptSoFar + sleptSoFar) + "ms  this time:" + sleepTime + "ms");
                ThreadUtil.sleep(sleepTime);
                sleepTime *= 2L;
                continue;
            }
            break;
        }
    }

    public int hashCode() {
        return this._hashCode;
    }

    public String host() {
        return this._addr.toString();
    }

    public String toString() {
        return "{DBPort  " + this.host() + "}";
    }

    protected void finalize() {
        this.close();
    }

    protected void close() {
        if (this._socket == null) {
            return;
        }
        try {
            this._socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._in = null;
        this._out = null;
        this._socket = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkAuth(DB db) {
        if (db._username == null) {
            return;
        }
        if (this._authed.containsKey(db)) {
            return;
        }
        if (this._inauth) {
            return;
        }
        this._inauth = true;
        OutMessage real = OutMessage.TL.get();
        OutMessage.TL.set(new OutMessage());
        try {
            if (db.reauth()) {
                this._authed.put(db, true);
                return;
            }
        }
        finally {
            this._inauth = false;
            OutMessage.TL.set(real);
        }
        throw new MongoInternalException("can't reauth!");
    }
}

