/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.Bytes;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.DBPointer;
import com.mongodb.DBRef;
import com.mongodb.MongoInternalException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBCallback
extends BasicBSONCallback {
    public static Factory FACTORY = new DefaultFactory();
    private String _lastName;
    private boolean _lastArray = false;
    final DBCollection _collection;
    final DB _db;
    static final Logger LOGGER = Logger.getLogger("com.mongo.DECODING");

    public DBCallback(DBCollection coll) {
        this._collection = coll;
        this._db = this._collection == null ? null : this._collection.getDB();
    }

    @Override
    public void gotDBRef(String name, String ns, ObjectId id) {
        if (id.equals(Bytes.COLLECTION_REF_ID)) {
            this.cur().put(name, this._collection);
        } else {
            this.cur().put(name, new DBPointer((DBObject)this.cur(), name, this._db, ns, id));
        }
    }

    @Override
    public void objectStart(boolean array, String name) {
        this._lastName = name;
        this._lastArray = array;
        super.objectStart(array, name);
    }

    @Override
    public BSONObject objectDone() {
        BSONObject o = super.objectDone();
        if (!this._lastArray && o.containsKey("$ref") && o.containsKey("$id")) {
            this.cur().put(this._lastName, new DBRef(this._db, o));
        }
        return o;
    }

    @Override
    public BSONObject create() {
        return this._create(null);
    }

    @Override
    public BSONObject create(boolean array, List<String> path) {
        if (array) {
            return new BasicDBList();
        }
        return this._create(path);
    }

    private DBObject _create(List<String> path) {
        Class c = null;
        if (this._collection != null && this._collection._objectClass != null) {
            if (path == null || path.size() == 0) {
                c = this._collection._objectClass;
            } else {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < path.size(); ++i) {
                    if (i > 0) {
                        buf.append(".");
                    }
                    buf.append(path.get(i));
                }
                c = this._collection.getInternalClass(buf.toString());
            }
        }
        if (c != null) {
            try {
                return (DBObject)c.newInstance();
            }
            catch (InstantiationException ie) {
                LOGGER.log(Level.FINE, "can't create a: " + c, ie);
                throw new MongoInternalException("can't instantiate a : " + c, ie);
            }
            catch (IllegalAccessException iae) {
                LOGGER.log(Level.FINE, "can't create a: " + c, iae);
                throw new MongoInternalException("can't instantiate a : " + c, iae);
            }
        }
        return new BasicDBObject();
    }

    DBObject dbget() {
        DBObject o = (DBObject)this.get();
        return o;
    }

    static class DefaultFactory
    implements Factory {
        DefaultFactory() {
        }

        public DBCallback create(DBCollection collection) {
            return new DBCallback(collection);
        }
    }

    public static interface Factory {
        public DBCallback create(DBCollection var1);
    }
}

