/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MapReduceOutput;
import com.mongodb.MongoException;
import com.mongodb.ObjectId;
import com.mongodb.ReflectionDBObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBCollection {
    static final boolean DEBUG = Boolean.getBoolean("DEBUG.DB");
    final DB _db;
    protected final String _name;
    protected final String _fullName;
    protected List<DBObject> _hintFields;
    private DB.WriteConcern _concern = null;
    protected Class _objectClass = null;
    private Map<String, Class> _internalClass = Collections.synchronizedMap(new HashMap());
    private ReflectionDBObject.JavaWrapper _wrapper = null;
    private boolean _anyUpdateSave = false;
    private boolean _checkedIdIndex = false;
    private final Set<String> _createIndexes = new HashSet<String>();
    private final Set<String> _createIndexesAfterSave = new HashSet<String>();
    private static final DBObject _upsertOptions = BasicDBObjectBuilder.start().add("upsert", true).get();
    private static final DBObject _idKey = BasicDBObjectBuilder.start().add("_id", 1).get();

    public abstract void insert(DBObject var1) throws MongoException;

    public abstract void insert(DBObject[] var1) throws MongoException;

    public abstract void insert(List<DBObject> var1) throws MongoException;

    public abstract void update(DBObject var1, DBObject var2, boolean var3, boolean var4) throws MongoException;

    public void update(DBObject q, DBObject o) throws MongoException {
        this.update(q, o, false, false);
    }

    public void updateMulti(DBObject q, DBObject o) throws MongoException {
        this.update(q, o, false, true);
    }

    protected abstract void doapply(DBObject var1);

    public abstract void remove(DBObject var1) throws MongoException;

    public abstract Iterator<DBObject> find(DBObject var1, DBObject var2, int var3, int var4) throws MongoException;

    public abstract void ensureIndex(DBObject var1, String var2) throws MongoException;

    public abstract void ensureIndex(DBObject var1, String var2, boolean var3) throws MongoException;

    public final DBObject findOne(Object obj) throws MongoException {
        return this.findOne(obj, null);
    }

    public final DBObject findOne(Object obj, DBObject fields) {
        this.ensureIDIndex();
        Iterator<DBObject> iterator = this.find(new BasicDBObject("_id", obj), fields, 0, -1);
        return iterator != null ? iterator.next() : null;
    }

    public void checkForIDIndex(DBObject key) throws MongoException {
        if (this._checkedIdIndex) {
            return;
        }
        if (key.get("_id") == null) {
            return;
        }
        if (key.keySet().size() > 1) {
            return;
        }
        this.ensureIDIndex();
    }

    public void ensureIDIndex() throws MongoException {
        if (this._checkedIdIndex) {
            return;
        }
        this.ensureIndex(_idKey);
        this._checkedIdIndex = true;
    }

    public final void ensureIndex(DBObject keys) throws MongoException {
        this.ensureIndex(keys, false);
    }

    public final void createIndex(DBObject keys) throws MongoException {
        this.ensureIndex(keys, true);
    }

    public final void ensureIndex(DBObject keys, boolean force) throws MongoException {
        this.ensureIndex(keys, force, false);
    }

    public final void ensureIndex(DBObject keys, boolean force, boolean unique) throws MongoException {
        if (this.checkReadOnly(false)) {
            return;
        }
        String name = DBCollection.genIndexName(keys);
        boolean doEnsureIndex = false;
        if (Math.random() > 0.999) {
            doEnsureIndex = true;
        } else if (!this._createIndexes.contains(name)) {
            doEnsureIndex = true;
        } else if (this._anyUpdateSave && !this._createIndexesAfterSave.contains(name)) {
            doEnsureIndex = true;
        }
        if (!force && !doEnsureIndex) {
            return;
        }
        this.ensureIndex(keys, name, unique);
        this._createIndexes.add(name);
        if (this._anyUpdateSave) {
            this._createIndexesAfterSave.add(name);
        }
    }

    public void resetIndexCache() {
        this._createIndexes.clear();
    }

    public static String genIndexName(DBObject keys) {
        String name = "";
        for (String s : keys.keySet()) {
            if (name.length() > 0) {
                name = name + "_";
            }
            name = name + s + "_";
            Object val = keys.get(s);
            if (!(val instanceof Number)) continue;
            name = name + val.toString().replace(' ', '_');
        }
        return name;
    }

    public void setHintFields(List<DBObject> lst) {
        this._hintFields = lst;
    }

    public final DBCursor find(DBObject ref) {
        return new DBCursor(this, ref, null);
    }

    public final DBCursor find(DBObject ref, DBObject keys) {
        return new DBCursor(this, ref, keys);
    }

    public final DBCursor find() {
        return new DBCursor(this, new BasicDBObject(), null);
    }

    public final DBObject findOne() throws MongoException {
        return this.findOne(new BasicDBObject());
    }

    public final DBObject findOne(DBObject o) throws MongoException {
        return this.findOne(o, null);
    }

    public final DBObject findOne(DBObject o, DBObject fields) {
        Iterator<DBObject> i = this.find(o, fields, 0, -1);
        if (i == null || !i.hasNext()) {
            return null;
        }
        return i.next();
    }

    public final Object apply(DBObject o) {
        return this.apply(o, true);
    }

    public final Object apply(DBObject jo, boolean ensureID) {
        Object id = jo.get("_id");
        if (ensureID && id == null) {
            id = ObjectId.get();
            jo.put("_id", id);
        }
        this.doapply(jo);
        return id;
    }

    public final void save(DBObject jo) throws MongoException {
        if (this.checkReadOnly(true)) {
            return;
        }
        this._checkObject(jo, false, false);
        Object id = jo.get("_id");
        if (DEBUG) {
            System.out.println("id : " + id);
        }
        if (id == null || id instanceof ObjectId && ((ObjectId)id)._new) {
            if (DEBUG) {
                System.out.println("saving new object");
            }
            if (id != null && id instanceof ObjectId) {
                ((ObjectId)id)._new = false;
            }
            this.insert(jo);
            return;
        }
        if (DEBUG) {
            System.out.println("doing implicit upsert : " + jo.get("_id"));
        }
        BasicDBObject q = new BasicDBObject();
        q.put("_id", id);
        this.update(q, jo, true, false);
    }

    public void dropIndexes() throws MongoException {
        this.dropIndexes("*");
    }

    public void dropIndexes(String name) throws MongoException {
        DBObject cmd = BasicDBObjectBuilder.start().add("deleteIndexes", this.getName()).add("index", name).get();
        BasicDBObject res = (BasicDBObject)this._db.command(cmd);
        if (res.getInt("ok", 0) != 1) {
            if (res.getString("errmsg").equals("ns not found")) {
                return;
            }
            throw new MongoException("error dropping indexes : " + res);
        }
        this.resetIndexCache();
    }

    public void drop() throws MongoException {
        BasicDBObject res = (BasicDBObject)this._db.command(BasicDBObjectBuilder.start().add("drop", this.getName()).get());
        if (res.getInt("ok", 0) != 1) {
            if (res.getString("errmsg").equals("ns not found")) {
                return;
            }
            throw new MongoException("error dropping : " + res);
        }
    }

    public long getCount() throws MongoException {
        return this.getCount(new BasicDBObject(), null);
    }

    public long getCount(DBObject query) throws MongoException {
        return this.getCount(query, null);
    }

    public long getCount(DBObject query, DBObject fields) throws MongoException {
        BasicDBObject res;
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("count", (Object)this.getName());
        cmd.put("query", (Object)query);
        if (fields != null) {
            cmd.put("fields", (Object)fields);
        }
        if ((res = (BasicDBObject)this._db.command(cmd)).getInt("ok", 0) != 1) {
            String errmsg = res.getString("errmsg");
            if (errmsg.equals("ns does not exist") || errmsg.equals("ns missing")) {
                return 0L;
            }
            throw new MongoException("error counting : " + res);
        }
        return res.getLong("n");
    }

    public void rename(String newName) throws MongoException {
        DBObject ret = this._db.getSisterDB("admin").command(BasicDBObjectBuilder.start().add("renameCollection", this._fullName).add("to", this._db._name + "." + newName).get());
        Number n = (Number)ret.get("ok");
        if (n.intValue() == 1) {
            return;
        }
        throw new MongoException("rename failed: " + ret);
    }

    public DBObject group(DBObject key, DBObject cond, DBObject initial, String reduce) throws MongoException {
        DBObject ret = this._db.command(new BasicDBObject("group", BasicDBObjectBuilder.start().add("ns", this.getName()).add("key", key).add("cond", cond).add("$reduce", reduce).add("initial", initial).get()));
        if (((Number)ret.get("ok")).intValue() == 1) {
            return (DBObject)ret.get("retval");
        }
        throw new MongoException("group failed: " + ret.toString());
    }

    public List distinct(String key) {
        return this.distinct(key, new BasicDBObject());
    }

    public List distinct(String key, DBObject query) {
        DBObject c = BasicDBObjectBuilder.start().add("distinct", this.getName()).add("key", key).add("query", query).get();
        DBObject res = this._db.command(c);
        if (!new Double(1.0).equals(res.get("ok"))) {
            throw new MongoException("distinct failed: " + res);
        }
        return (List)res.get("values");
    }

    public MapReduceOutput mapReduce(String map, String reduce, String outputCollection, DBObject query) throws MongoException {
        BasicDBObjectBuilder b = BasicDBObjectBuilder.start().add("mapreduce", this._name).add("map", map).add("reduce", reduce);
        if (outputCollection != null) {
            b.add("out", outputCollection);
        }
        if (query != null) {
            b.add("query", query);
        }
        return this.mapReduce(b.get());
    }

    public MapReduceOutput mapReduce(DBObject command) throws MongoException {
        if (command.get("mapreduce") == null) {
            throw new IllegalArgumentException("need mapreduce arg");
        }
        BasicDBObject res = (BasicDBObject)this._db.command(command);
        if (res.getInt("ok") != 1) {
            throw new MongoException("mapreduce failed: " + res);
        }
        return new MapReduceOutput(this, res);
    }

    public List<DBObject> getIndexInfo() {
        BasicDBObject cmd = new BasicDBObject();
        cmd.put("ns", (Object)this.getFullName());
        DBCursor cur = this._db.getCollection("system.indexes").find(cmd);
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        while (cur.hasNext()) {
            list.add(cur.next());
        }
        return list;
    }

    public void dropIndex(DBObject keys) throws MongoException {
        this.dropIndexes(DBCollection.genIndexName(keys));
    }

    public void dropIndex(String name) throws MongoException {
        this.dropIndexes(name);
    }

    protected DBCollection(DB base, String name) {
        this._db = base;
        this._name = name;
        this._fullName = this._db.getName() + "." + name;
    }

    private DBObject _checkObject(DBObject o, boolean canBeNull, boolean query) {
        if (o == null) {
            if (canBeNull) {
                return null;
            }
            throw new IllegalArgumentException("can't be null");
        }
        if (o.isPartialObject() && !query) {
            throw new IllegalArgumentException("can't save partial objects");
        }
        if (!query) {
            this._checkKeys(o);
        }
        return o;
    }

    private void _checkKeys(DBObject o) {
        for (String s : o.keySet()) {
            if (s.contains(".")) {
                throw new IllegalArgumentException("fields stored in the db can't have . in them");
            }
            if (s.contains("$")) {
                throw new IllegalArgumentException("fields stored in the db can't have $ in them");
            }
            Object inner = o.get(s);
            if (!(inner instanceof DBObject)) continue;
            this._checkKeys((DBObject)inner);
        }
    }

    public DBCollection getCollection(String n) {
        return this._db.getCollection(this._name + "." + n);
    }

    public String getName() {
        return this._name;
    }

    public String getFullName() {
        return this._fullName;
    }

    public DB getDB() {
        return this._db;
    }

    protected boolean checkReadOnly(boolean strict) {
        if (!this._db._readOnly) {
            return false;
        }
        if (!strict) {
            return true;
        }
        throw new IllegalStateException("db is read only");
    }

    public int hashCode() {
        return this._fullName.hashCode();
    }

    public boolean equals(Object o) {
        return o == this;
    }

    public String toString() {
        return this._name;
    }

    public void setObjectClass(Class c) {
        if (!DBObject.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException(c.getName() + " is not a DBObject");
        }
        this._objectClass = c;
        this._wrapper = ReflectionDBObject.class.isAssignableFrom(c) ? ReflectionDBObject.getWrapper(c) : null;
    }

    public Class getObjectClass() {
        return this._objectClass;
    }

    public void setInternalClass(String path, Class c) {
        this._internalClass.put(path, c);
    }

    protected Class getInternalClass(String path) {
        Class c = this._internalClass.get(path);
        if (c != null) {
            return c;
        }
        if (this._wrapper == null) {
            return null;
        }
        return this._wrapper.getInternalClass(path);
    }

    public void setWriteConcern(DB.WriteConcern concern) {
        this._concern = concern;
    }

    public DB.WriteConcern getWriteConcern() {
        if (this._concern != null) {
            return this._concern;
        }
        return this._db.getWriteConcern();
    }
}

