/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.HashMap;
import java.util.Map;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

public abstract class AbstractMapCodec<T>
implements Codec<Map<String, T>> {
    abstract T readValue(BsonReader var1, DecoderContext var2);

    abstract void writeValue(BsonWriter var1, T var2, EncoderContext var3);

    @Override
    public void encode(BsonWriter writer, Map<String, T> map, EncoderContext encoderContext) {
        writer.writeStartDocument();
        for (Map.Entry<String, T> entry : map.entrySet()) {
            writer.writeName(entry.getKey());
            T value = entry.getValue();
            if (value == null) {
                writer.writeNull();
                continue;
            }
            this.writeValue(writer, value, encoderContext);
        }
        writer.writeEndDocument();
    }

    @Override
    public Map<String, T> decode(BsonReader reader, DecoderContext decoderContext) {
        HashMap<String, T> map = new HashMap<String, T>();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                map.put(fieldName, null);
                continue;
            }
            map.put(fieldName, this.readValue(reader, decoderContext));
        }
        reader.readEndDocument();
        return map;
    }

    @Override
    public Class<Map<String, T>> getEncoderClass() {
        return Map.class;
    }
}

