/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs;

import java.util.ArrayList;
import org.bson.BsonReader;
import org.bson.BsonType;
import org.bson.BsonWriter;
import org.bson.codecs.Codec;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.EncoderContext;

abstract class AbstractIterableCodec<T>
implements Codec<Iterable<T>> {
    AbstractIterableCodec() {
    }

    abstract T readValue(BsonReader var1, DecoderContext var2);

    abstract void writeValue(BsonWriter var1, T var2, EncoderContext var3);

    @Override
    public Iterable<T> decode(BsonReader reader, DecoderContext decoderContext) {
        reader.readStartArray();
        ArrayList<T> list = new ArrayList<T>();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                list.add(null);
                continue;
            }
            list.add(this.readValue(reader, decoderContext));
        }
        reader.readEndArray();
        return list;
    }

    @Override
    public void encode(BsonWriter writer, Iterable<T> value, EncoderContext encoderContext) {
        writer.writeStartArray();
        for (T cur : value) {
            if (cur == null) {
                writer.writeNull();
                continue;
            }
            this.writeValue(writer, cur, encoderContext);
        }
        writer.writeEndArray();
    }

    @Override
    public Class<Iterable<T>> getEncoderClass() {
        return Iterable.class;
    }
}

