/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.lang.reflect.Field;
import org.bson.codecs.configuration.CodecConfigurationException;
import org.bson.codecs.pojo.FieldAccessor;

final class FieldAccessorImpl<T>
implements FieldAccessor<T> {
    private final Field field;
    private final String fieldName;

    FieldAccessorImpl(Field field, String fieldName) {
        this.field = field;
        this.fieldName = fieldName;
    }

    @Override
    public <S> T get(S instance) {
        try {
            return (T)this.field.get(instance);
        }
        catch (IllegalAccessException e) {
            throw new CodecConfigurationException(String.format("Unable to get value for field: %s", this.fieldName), e);
        }
        catch (IllegalArgumentException e) {
            throw new CodecConfigurationException(String.format("Unable to get value for field: %s", this.fieldName), e);
        }
    }

    @Override
    public <S> void set(S instance, T value) {
        try {
            this.field.set(instance, value);
        }
        catch (IllegalAccessException e) {
            throw new CodecConfigurationException(String.format("Unable to set value '%s' for field: %s", value, this.fieldName), e);
        }
        catch (IllegalArgumentException e) {
            throw new CodecConfigurationException(String.format("Unable to set value '%s' for field: %s", value, this.fieldName), e);
        }
    }
}

