/*
 * Decompiled with CFR 0.152.
 */
package org.bson.codecs.pojo;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bson.codecs.pojo.ClassModelBuilder;
import org.bson.codecs.pojo.FieldModel;
import org.bson.codecs.pojo.InstanceCreator;
import org.bson.codecs.pojo.InstanceCreatorFactory;
import org.bson.codecs.pojo.TypeParameterMap;

public final class ClassModel<T> {
    private final String name;
    private final Class<T> type;
    private final boolean hasTypeParameters;
    private final InstanceCreatorFactory<T> instanceCreatorFactory;
    private final boolean discriminatorEnabled;
    private final String discriminatorKey;
    private final String discriminator;
    private final FieldModel<?> idField;
    private final List<FieldModel<?>> fieldModels;
    private final Map<String, TypeParameterMap> fieldNameToTypeParameterMap;
    private final Map<String, FieldModel<?>> fieldMap;

    ClassModel(Class<T> clazz, Map<String, TypeParameterMap> fieldNameToTypeParameterMap, InstanceCreatorFactory<T> instanceCreatorFactory, Boolean discriminatorEnabled, String discriminatorKey, String discriminator, FieldModel<?> idField, List<FieldModel<?>> fieldModels) {
        this.name = clazz.getSimpleName();
        this.type = clazz;
        this.hasTypeParameters = clazz.getTypeParameters().length > 0;
        this.fieldNameToTypeParameterMap = fieldNameToTypeParameterMap;
        this.instanceCreatorFactory = instanceCreatorFactory;
        this.discriminatorEnabled = discriminatorEnabled;
        this.discriminatorKey = discriminatorKey;
        this.discriminator = discriminator;
        this.idField = idField;
        this.fieldModels = fieldModels;
        this.fieldMap = ClassModel.generateFieldMap(fieldModels);
    }

    public static <S> ClassModelBuilder<S> builder(Class<S> type) {
        return new ClassModelBuilder<S>(type);
    }

    InstanceCreator<T> getInstanceCreator() {
        return this.instanceCreatorFactory.create();
    }

    public Class<T> getType() {
        return this.type;
    }

    public boolean hasTypeParameters() {
        return this.hasTypeParameters;
    }

    public boolean useDiscriminator() {
        return this.discriminatorEnabled;
    }

    public String getDiscriminatorKey() {
        return this.discriminatorKey;
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public FieldModel<?> getFieldModel(String documentFieldName) {
        return this.fieldMap.get(documentFieldName);
    }

    public List<FieldModel<?>> getFieldModels() {
        return this.fieldModels;
    }

    public FieldModel<?> getIdFieldModel() {
        return this.idField;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "ClassModel{type=" + this.type + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassModel that = (ClassModel)o;
        if (this.discriminatorEnabled != that.discriminatorEnabled) {
            return false;
        }
        if (!this.getType().equals(that.getType())) {
            return false;
        }
        if (!this.getInstanceCreatorFactory().equals(that.getInstanceCreatorFactory())) {
            return false;
        }
        if (this.getDiscriminatorKey() != null ? !this.getDiscriminatorKey().equals(that.getDiscriminatorKey()) : that.getDiscriminatorKey() != null) {
            return false;
        }
        if (this.getDiscriminator() != null ? !this.getDiscriminator().equals(that.getDiscriminator()) : that.getDiscriminator() != null) {
            return false;
        }
        if (this.idField != null ? !this.idField.equals(that.idField) : that.idField != null) {
            return false;
        }
        if (!this.getFieldModels().equals(that.getFieldModels())) {
            return false;
        }
        return this.getFieldNameToTypeParameterMap().equals(that.getFieldNameToTypeParameterMap());
    }

    public int hashCode() {
        int result = this.getType().hashCode();
        result = 31 * result + this.getInstanceCreatorFactory().hashCode();
        result = 31 * result + (this.discriminatorEnabled ? 1 : 0);
        result = 31 * result + (this.getDiscriminatorKey() != null ? this.getDiscriminatorKey().hashCode() : 0);
        result = 31 * result + (this.getDiscriminator() != null ? this.getDiscriminator().hashCode() : 0);
        result = 31 * result + (this.idField != null ? this.idField.hashCode() : 0);
        result = 31 * result + this.getFieldModels().hashCode();
        result = 31 * result + this.getFieldNameToTypeParameterMap().hashCode();
        return result;
    }

    InstanceCreatorFactory<T> getInstanceCreatorFactory() {
        return this.instanceCreatorFactory;
    }

    Map<String, TypeParameterMap> getFieldNameToTypeParameterMap() {
        return this.fieldNameToTypeParameterMap;
    }

    private static Map<String, FieldModel<?>> generateFieldMap(List<FieldModel<?>> fieldModels) {
        HashMap fieldMap = new HashMap();
        for (FieldModel<?> fieldModel : fieldModels) {
            fieldMap.put(fieldModel.getDocumentFieldName(), fieldModel);
        }
        return fieldMap;
    }
}

