/*
 * Copyright 2017 MongoDB, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.bson.codecs.pojo;

final class ConventionDefaultsImpl implements Convention {
    @Override
    public void apply(final ClassModelBuilder<?> classModelBuilder) {

        if (classModelBuilder.getDiscriminatorKey() == null) {
            classModelBuilder.discriminatorKey("_t");
        }
        if (classModelBuilder.getDiscriminator() == null && classModelBuilder.getType() != null) {
            classModelBuilder.discriminator(classModelBuilder.getType().getSimpleName());
        }

       for (final FieldModelBuilder<?> fieldModel : classModelBuilder.getFields()) {
            if (fieldModel.getDocumentFieldName() == null) {
                fieldModel.documentFieldName(fieldModel.getFieldName());
            }

            if (classModelBuilder.getIdField() == null) {
                String fieldName = fieldModel.getFieldName();
                if (fieldName.equals("_id") || fieldName.equals("id")) {
                    classModelBuilder.idField(fieldName);
                }
            }
        }
    }
}
